/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.common.iterator.CloseableIterator;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.vertex.IVertex;
import org.apache.geaflow.state.data.DataType;
import org.apache.geaflow.state.data.OneDegreeGraph;
import org.apache.geaflow.state.iterator.IteratorWithClose;
import org.apache.geaflow.state.iterator.IteratorWithFilterThenFn;
import org.apache.geaflow.state.iterator.IteratorWithFlatFn;
import org.apache.geaflow.state.iterator.IteratorWithFn;
import org.apache.geaflow.state.pushdown.IStatePushDown;
import org.apache.geaflow.state.pushdown.filter.inner.IGraphFilter;
import org.apache.geaflow.store.api.graph.BaseGraphStore;
import org.apache.geaflow.store.api.graph.IDynamicGraphStore;
import org.apache.geaflow.store.context.StoreContext;
import org.apache.geaflow.store.iterator.KeysIterator;
import org.apache.geaflow.store.memory.iterator.MemoryEdgeScanPushDownIterator;
import org.apache.geaflow.store.memory.iterator.MemoryVertexScanIterator;

public class DynamicGraphMemoryStore<K, VV, EV>
extends BaseGraphStore
implements IDynamicGraphStore<K, VV, EV> {
    private Map<K, Map<Long, List<IEdge<K, EV>>>> vertexId2Edges = new ConcurrentHashMap<K, Map<Long, List<IEdge<K, EV>>>>();
    private Map<K, Map<Long, IVertex<K, VV>>> vertexId2Vertex = new ConcurrentHashMap<K, Map<Long, IVertex<K, VV>>>();

    public void init(StoreContext context) {
        super.init(context);
    }

    public void archive(long checkpointId) {
    }

    public void recovery(long checkpointId) {
    }

    public long recoveryLatest() {
        return 0L;
    }

    public void compact() {
    }

    public void flush() {
    }

    public void close() {
        this.vertexId2Edges.clear();
        this.vertexId2Vertex.clear();
    }

    public void drop() {
        this.vertexId2Edges = null;
        this.vertexId2Vertex = null;
    }

    public Map<K, List<IEdge<K, EV>>> getVertexId2Edges(long version) {
        HashMap<K, List<IEdge<K, EV>>> map = new HashMap<K, List<IEdge<K, EV>>>(this.vertexId2Edges.size());
        for (Map.Entry<K, Map<Long, List<IEdge<K, EV>>>> entry : this.vertexId2Edges.entrySet()) {
            if (!entry.getValue().containsKey(version)) continue;
            map.put(entry.getKey(), entry.getValue().get(version));
        }
        return map;
    }

    public Map<K, IVertex<K, VV>> getVertexId2Vertex(long version) {
        HashMap<K, IVertex<K, VV>> map = new HashMap<K, IVertex<K, VV>>(this.vertexId2Vertex.size());
        for (Map.Entry<K, Map<Long, IVertex<K, VV>>> entry : this.vertexId2Vertex.entrySet()) {
            if (!entry.getValue().containsKey(version)) continue;
            map.put(entry.getKey(), entry.getValue().get(version));
        }
        return map;
    }

    private Iterator<K> getKeyIterator() {
        HashSet<K> keys = new HashSet<K>(this.vertexId2Vertex.keySet());
        keys.addAll(this.vertexId2Edges.keySet());
        return keys.iterator();
    }

    public void addEdge(long version, IEdge<K, EV> edge) {
        Object srcId = edge.getSrcId();
        Map map = this.vertexId2Edges.computeIfAbsent(srcId, k -> new HashMap());
        List edges = map.computeIfAbsent(version, k -> new ArrayList());
        edges.add(edge);
    }

    public void addVertex(long version, IVertex<K, VV> vertex) {
        Object id = vertex.getId();
        Map map = this.vertexId2Vertex.computeIfAbsent(id, k -> new HashMap());
        map.put(version, vertex);
    }

    public IVertex<K, VV> getVertex(long version, K sid, IStatePushDown pushdown) {
        Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(sid);
        IVertex<K, VV> vertex = null;
        if (map != null) {
            vertex = map.get(version);
        }
        if (vertex != null && ((IGraphFilter)pushdown.getFilter()).filterVertex(vertex)) {
            return vertex;
        }
        return null;
    }

    public List<IEdge<K, EV>> getEdges(long version, K sid, IStatePushDown pushdown) {
        Map<Long, List<IEdge<K, EV>>> map = this.vertexId2Edges.get(sid);
        List list = new ArrayList();
        if (map != null) {
            list = map.getOrDefault(version, new ArrayList());
        }
        IGraphFilter filter = (IGraphFilter)pushdown.getFilter();
        return list.stream().filter(arg_0 -> ((IGraphFilter)filter).filterEdge(arg_0)).collect(Collectors.toList());
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(long version, K sid, IStatePushDown pushdown) {
        IVertex<K, VV> vertex = this.getVertex(version, sid, pushdown);
        List<IEdge<K, EV>> edgeList = this.getEdges(version, sid, pushdown);
        OneDegreeGraph oneDegreeGraph = new OneDegreeGraph(sid, vertex, (CloseableIterator)IteratorWithClose.wrap(edgeList.iterator()));
        if (((IGraphFilter)pushdown.getFilter()).filterOneDegreeGraph(oneDegreeGraph)) {
            return oneDegreeGraph;
        }
        return null;
    }

    public CloseableIterator<K> vertexIDIterator() {
        return IteratorWithClose.wrap(this.vertexId2Vertex.keySet().iterator());
    }

    public CloseableIterator<K> vertexIDIterator(long version, IStatePushDown pushdown) {
        if (pushdown.getFilter() == null) {
            return new IteratorWithFilterThenFn(this.vertexId2Vertex.entrySet().iterator(), entry -> ((Map)entry.getValue()).containsKey(version), Map.Entry::getKey);
        }
        return new IteratorWithFn(this.getVertexIterator(version, pushdown), IVertex::getId);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(long version, IStatePushDown pushdown) {
        return new MemoryVertexScanIterator(this.getVertexId2Vertex(version).values().iterator(), (IGraphFilter)pushdown.getFilter());
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(long version, List<K> keys, IStatePushDown pushdown) {
        BiFunction<Object, IStatePushDown, IVertex> fetchFun = (k, p) -> this.getVertex(version, (K)k, (IStatePushDown)p);
        return new KeysIterator(keys, fetchFun, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(long version, IStatePushDown pushdown) {
        MemoryEdgeScanPushDownIterator it = new MemoryEdgeScanPushDownIterator(this.getVertexId2Edges(version).values().iterator(), pushdown);
        return new IteratorWithFlatFn(it, List::iterator);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(long version, List<K> keys, IStatePushDown pushdown) {
        BiFunction<Object, IStatePushDown, List> fetchFun = (k, p) -> this.getEdges(version, (K)k, (IStatePushDown)p);
        KeysIterator it = new KeysIterator(keys, fetchFun, pushdown);
        return new IteratorWithFlatFn((Iterator)it, List::iterator);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, IStatePushDown pushdown) {
        BiFunction<Object, IStatePushDown, OneDegreeGraph> fetchFun = (k, p) -> this.getOneDegreeGraph(version, (K)k, (IStatePushDown)p);
        return new KeysIterator((List)Lists.newArrayList(this.getKeyIterator()), fetchFun, pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, List<K> keys, IStatePushDown pushdown) {
        BiFunction<Object, IStatePushDown, OneDegreeGraph> fetchFun = (k, p) -> this.getOneDegreeGraph(version, (K)k, (IStatePushDown)p);
        return new KeysIterator(keys, fetchFun, pushdown);
    }

    public List<Long> getAllVersions(K id, DataType dataType) {
        if (dataType == DataType.V || dataType == DataType.V_TOPO) {
            Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(id);
            if (map != null) {
                return new ArrayList<Long>(map.keySet());
            }
            return new ArrayList<Long>();
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    public long getLatestVersion(K id, DataType dataType) {
        if (dataType == DataType.V || dataType == DataType.V_TOPO) {
            Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(id);
            if (map != null) {
                return (Long)map.keySet().stream().max(Long::compare).get();
            }
            return -1L;
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    public Map<Long, IVertex<K, VV>> getAllVersionData(K id, IStatePushDown pushdown, DataType dataType) {
        if (dataType != DataType.V) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
        }
        Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(id);
        HashMap<Long, IVertex<Long, VV>> res = new HashMap<Long, IVertex<Long, VV>>(map.size());
        IGraphFilter graphFilter = (IGraphFilter)pushdown.getFilter();
        for (Map.Entry<Long, IVertex<K, VV>> entry : map.entrySet()) {
            if (!graphFilter.filterVertex(entry.getValue())) continue;
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public Map<Long, IVertex<K, VV>> getVersionData(K id, Collection<Long> versions, IStatePushDown pushdown, DataType dataType) {
        if (dataType != DataType.V) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
        }
        Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(id);
        HashMap<Long, IVertex<Long, VV>> res = new HashMap<Long, IVertex<Long, VV>>(versions.size());
        IGraphFilter graphFilter = (IGraphFilter)pushdown.getFilter();
        for (long version : versions) {
            IVertex<K, VV> vertex = map.get(version);
            if (vertex == null || !graphFilter.filterVertex(vertex)) continue;
            res.put(version, vertex);
        }
        return res;
    }
}

