/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.geaflow.common.iterator.CloseableIterator;
import org.apache.geaflow.common.tuple.Tuple;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.vertex.IVertex;
import org.apache.geaflow.state.data.OneDegreeGraph;
import org.apache.geaflow.state.graph.encoder.EdgeAtom;
import org.apache.geaflow.state.iterator.IteratorWithClose;
import org.apache.geaflow.state.iterator.IteratorWithFlatFn;
import org.apache.geaflow.state.iterator.IteratorWithFn;
import org.apache.geaflow.state.pushdown.IStatePushDown;
import org.apache.geaflow.state.pushdown.StatePushDown;
import org.apache.geaflow.state.pushdown.filter.FilterType;
import org.apache.geaflow.state.pushdown.filter.IFilter;
import org.apache.geaflow.state.pushdown.filter.inner.GraphFilter;
import org.apache.geaflow.state.pushdown.filter.inner.IGraphFilter;
import org.apache.geaflow.state.pushdown.limit.IEdgeLimit;
import org.apache.geaflow.store.api.graph.BaseGraphStore;
import org.apache.geaflow.store.api.graph.IStaticGraphStore;
import org.apache.geaflow.store.context.StoreContext;
import org.apache.geaflow.store.iterator.KeysIterator;
import org.apache.geaflow.store.memory.iterator.MemoryEdgeScanPushDownIterator;
import org.apache.geaflow.store.memory.iterator.MemoryVertexScanIterator;

public abstract class BaseStaticGraphMemoryStore<K, VV, EV>
extends BaseGraphStore
implements IStaticGraphStore<K, VV, EV> {
    public void init(StoreContext context) {
        super.init(context);
    }

    protected abstract IVertex<K, VV> getVertex(K var1);

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        IVertex<K, VV> vertex = this.getVertex(sid);
        return vertex != null && ((IGraphFilter)pushdown.getFilter()).filterVertex(vertex) ? vertex : null;
    }

    protected abstract List<IEdge<K, EV>> getEdges(K var1);

    protected List<IEdge<K, EV>> pushdownEdges(List<IEdge<K, EV>> list, IStatePushDown pushdown) {
        if (pushdown.getOrderFields() != null) {
            list.sort(EdgeAtom.getComparator((List)pushdown.getOrderFields()));
        }
        ArrayList<IEdge<K, EV>> res = new ArrayList<IEdge<K, EV>>(list.size());
        Iterator<IEdge<K, EV>> it = list.iterator();
        IGraphFilter filter = GraphFilter.of((IFilter)pushdown.getFilter(), (IEdgeLimit)pushdown.getEdgeLimit());
        while (it.hasNext() && !filter.dropAllRemaining()) {
            IEdge<K, EV> edge = it.next();
            if (!filter.filterEdge(edge)) continue;
            res.add(edge);
        }
        return res;
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        return this.pushdownEdges(this.getEdges(sid), pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        IVertex<K, VV> vertex = this.getVertex(sid, pushdown);
        List<IEdge<K, EV>> edges = this.getEdges(sid, pushdown);
        OneDegreeGraph oneDegreeGraph = new OneDegreeGraph(sid, vertex, (CloseableIterator)IteratorWithClose.wrap(edges.iterator()));
        if (((IGraphFilter)pushdown.getFilter()).filterOneDegreeGraph(oneDegreeGraph)) {
            return oneDegreeGraph;
        }
        return null;
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        boolean emptyFilter = pushdown.getFilter().getFilterType() == FilterType.EMPTY;
        return emptyFilter ? this.getVertexIterator() : new MemoryVertexScanIterator(this.getVertexIterator(), (IGraphFilter)pushdown.getFilter());
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(List<K> list, IStatePushDown pushdown) {
        return new KeysIterator(list, this::getVertex, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        MemoryEdgeScanPushDownIterator it = new MemoryEdgeScanPushDownIterator(this.getEdgesIterator(), pushdown);
        return new IteratorWithFlatFn(it, List::iterator);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(List<K> list, IStatePushDown pushdown) {
        KeysIterator it = new KeysIterator(list, this::getEdges, pushdown);
        return new IteratorWithFlatFn((CloseableIterator)it, List::iterator);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        return new KeysIterator((List)Lists.newArrayList(this.getKeyIterator()), this::getOneDegreeGraph, pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        return new KeysIterator(keys, this::getOneDegreeGraph, pushdown);
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return new IteratorWithFn(this.getEdgeIterator(pushdown), edge -> Tuple.of((Object)edge.getSrcId(), (Object)pushdown.getProjector().project(edge)));
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return new IteratorWithFn(this.getEdgeIterator(keys, pushdown), edge -> Tuple.of((Object)edge.getSrcId(), (Object)pushdown.getProjector().project(edge)));
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        HashMap res = new HashMap();
        CloseableIterator<K> keyIt = this.getKeyIterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            List list = this.getEdges(key, pushdown);
            res.put(key, Long.valueOf(list.size()));
        }
        return res;
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        HashMap<K, Long> res = new HashMap<K, Long>(keys.size());
        Function<Object, IStatePushDown> pushdownFun = pushdown.getFilters() == null ? key -> pushdown : key -> StatePushDown.of().withFilter((IFilter)((IGraphFilter)pushdown.getFilters().get(key)));
        for (K key2 : keys) {
            List<IEdge<K, EV>> list = this.getEdges(key2, pushdownFun.apply(key2));
            res.put(key2, Long.valueOf(list.size()));
        }
        return res;
    }

    protected abstract CloseableIterator<List<IEdge<K, EV>>> getEdgesIterator();

    protected abstract CloseableIterator<IVertex<K, VV>> getVertexIterator();

    public CloseableIterator<K> vertexIDIterator() {
        return new IteratorWithFn(this.getVertexIterator(), IVertex::getId);
    }

    public CloseableIterator<K> vertexIDIterator(IStatePushDown pushDown) {
        if (pushDown.getFilter() == null) {
            return this.vertexIDIterator();
        }
        return new IteratorWithFn(this.getVertexIterator(pushDown), IVertex::getId);
    }

    protected abstract CloseableIterator<K> getKeyIterator();
}

