/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.worker;

import org.apache.geaflow.cluster.protocol.ICommand;
import org.apache.geaflow.cluster.protocol.IComposeEvent;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.cluster.task.runner.AbstractTaskRunner;
import org.apache.geaflow.cluster.task.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
extends AbstractTaskRunner<ICommand> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private TaskService taskService;

    public Dispatcher(TaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    protected void process(ICommand command) {
        switch (command.getEventType()) {
            case COMPOSE: {
                for (IEvent event : ((IComposeEvent)((Object)command)).getEventList()) {
                    this.process((ICommand)event);
                }
                break;
            }
            case INTERRUPT_TASK: {
                LOGGER.info("{} interrupt current running task", (Object)command.getWorkerId());
                this.taskService.interrupt(command.getWorkerId());
                break;
            }
            default: {
                this.taskService.process(command.getWorkerId(), command);
            }
        }
    }
}

