/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.metrics;

import com.baidu.brpc.server.RpcServerOptions;
import java.io.Serializable;
import org.apache.geaflow.cluster.rpc.RpcService;
import org.apache.geaflow.cluster.rpc.impl.MetricEndpoint;
import org.apache.geaflow.cluster.rpc.impl.RpcServiceImpl;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.rpc.ConfigurableServerOption;
import org.apache.geaflow.common.utils.PortUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricServer
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricServer.class);
    private final int port;
    private RpcService rpcService;

    public MetricServer(Configuration configuration) {
        this.port = configuration.getInteger(ExecutionConfigKeys.METRIC_SERVICE_PORT);
        if (configuration.getBoolean(ExecutionConfigKeys.HTTP_REST_SERVICE_ENABLE)) {
            RpcServerOptions serverOptions = this.getServerOptions(configuration);
            RpcServiceImpl rpcService = new RpcServiceImpl(PortUtil.getPort((int)this.port), serverOptions);
            rpcService.addEndpoint(new MetricEndpoint(configuration));
            this.rpcService = rpcService;
        }
    }

    private RpcServerOptions getServerOptions(Configuration configuration) {
        RpcServerOptions serverOptions = ConfigurableServerOption.build((Configuration)configuration);
        serverOptions.setGlobalThreadPoolSharing(false);
        serverOptions.setIoThreadNum(1);
        serverOptions.setWorkThreadNum(2);
        return serverOptions;
    }

    public int start() {
        if (this.rpcService != null) {
            int metricPort = this.rpcService.startService();
            LOGGER.info("started metric service on port:{}", (Object)metricPort);
            return metricPort;
        }
        return this.port;
    }

    public void stop() {
        if (this.rpcService != null) {
            LOGGER.info("stopping metric query service");
            this.rpcService.stopService();
        }
    }
}

