/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.cluster.web.metrics.MetricFetcher;
import org.apache.geaflow.common.metric.CycleMetrics;
import org.apache.geaflow.common.metric.PipelineMetrics;
import org.apache.geaflow.stats.model.MetricCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/pipelines")
public class PipelineRestHandler
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineRestHandler.class);
    private final MetricCache metricCache;
    private final MetricFetcher metricFetcher;

    public PipelineRestHandler(MetricCache metricCache, MetricFetcher metricFetcher) {
        this.metricCache = metricCache;
        this.metricFetcher = metricFetcher;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public ApiResponse<List<PipelineMetrics>> queryPipelineList() {
        try {
            this.metricFetcher.update();
            ArrayList<PipelineMetrics> list = new ArrayList<PipelineMetrics>();
            for (MetricCache.PipelineMetricCache cache : this.metricCache.getPipelineMetricCaches().values()) {
                if (cache.getPipelineMetrics() == null) continue;
                list.add(cache.getPipelineMetrics());
            }
            return ApiResponse.success(list);
        }
        catch (Throwable t) {
            LOGGER.error("Query pipeline list failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/{pipelineName}/cycles")
    @Produces(value={"application/json"})
    public ApiResponse<Collection<CycleMetrics>> queryCycleList(@PathParam(value="pipelineName") String pipelineName) {
        try {
            this.metricFetcher.update();
            MetricCache.PipelineMetricCache cache = (MetricCache.PipelineMetricCache)this.metricCache.getPipelineMetricCaches().get(pipelineName);
            if (cache == null) {
                return ApiResponse.success(Collections.EMPTY_LIST);
            }
            return ApiResponse.success(cache.getCycleMetricList().values());
        }
        catch (Throwable t) {
            LOGGER.error("Query cycle metric list of pipeline {} failed. {}", new Object[]{pipelineName, t.getMessage(), t});
            return ApiResponse.error(t);
        }
    }
}

