/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.handler;

import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.geaflow.cluster.common.ComponentInfo;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.metric.ProcessMetrics;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/master")
public class MasterRestHandler
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MasterRestHandler.class);
    private final Configuration configuration;
    private final ComponentInfo componentInfo;

    public MasterRestHandler(ComponentInfo componentInfo, Configuration configuration) {
        this.configuration = configuration;
        this.componentInfo = componentInfo;
    }

    @GET
    @Path(value="/configuration")
    @Produces(value={"application/json"})
    public ApiResponse<Map<String, String>> queryConfiguration() {
        try {
            return ApiResponse.success(this.configuration.getConfigMap());
        }
        catch (Throwable t) {
            LOGGER.error("Query master configuration failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json"})
    public ApiResponse<ProcessMetrics> queryProcessMetrics() {
        try {
            return ApiResponse.success(StatsCollectorFactory.init((Configuration)this.configuration).getProcessStatsCollector().collect());
        }
        catch (Throwable t) {
            LOGGER.error("Query master process metrics failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public ApiResponse<ComponentInfo> queryMasterInfo() {
        try {
            return ApiResponse.success(this.componentInfo);
        }
        catch (Throwable t) {
            LOGGER.error("Query master process metrics failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }
}

