/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.handler;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.geaflow.cluster.clustermanager.AbstractClusterManager;
import org.apache.geaflow.cluster.clustermanager.IClusterManager;
import org.apache.geaflow.cluster.common.ComponentInfo;
import org.apache.geaflow.cluster.container.ContainerInfo;
import org.apache.geaflow.cluster.driver.DriverInfo;
import org.apache.geaflow.cluster.heartbeat.HeartbeatManager;
import org.apache.geaflow.cluster.resourcemanager.DefaultResourceManager;
import org.apache.geaflow.cluster.resourcemanager.IResourceManager;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.cluster.web.metrics.MetricFetcher;
import org.apache.geaflow.cluster.web.metrics.ResourceMetrics;
import org.apache.geaflow.common.heartbeat.Heartbeat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ClusterRestHandler
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterRestHandler.class);
    private static final String TOTAL_CONTAINER_NUM = "totalContainers";
    private static final String TOTAL_DRIVER_NUM = "totalDrivers";
    private static final String ACTIVE_CONTAINER_NUM = "activeContainers";
    private static final String ACTIVE_DRIVER_NUM = "activeDrivers";
    private static final String TOTAL_WORKER_NUM = "totalWorkers";
    private static final String USED_WORKER_NUM = "usedWorkers";
    private static final String AVAILABLE_WORKER_NUM = "availableWorkers";
    private static final String PENDING_WORKER_NUM = "pendingWorkers";
    private static final String CONTAINER_ID_KEY = "id";
    private static final String CONTAINER_NAME_KEY = "name";
    private static final String CONTAINER_HOST_KEY = "host";
    private static final String PROCESS_ID_KEY = "pid";
    private static final String AGENT_PORT_KEY = "agentPort";
    private static final String PROCESS_METRICS_KEY = "metrics";
    private static final String LAST_UPDATE_TIME = "lastTimestamp";
    private static final String IS_ACTIVE = "isActive";
    private final AbstractClusterManager clusterManager;
    private final HeartbeatManager heartbeatManager;
    private final IResourceManager resourceManager;
    private final MetricFetcher metricFetcher;

    public ClusterRestHandler(IClusterManager clusterManager, HeartbeatManager heartbeatManager, IResourceManager resourceManager, MetricFetcher metricFetcher) {
        this.clusterManager = (AbstractClusterManager)clusterManager;
        this.heartbeatManager = heartbeatManager;
        this.resourceManager = resourceManager;
        this.metricFetcher = metricFetcher;
    }

    @GET
    @Path(value="/overview")
    @Produces(value={"application/json"})
    public ApiResponse<Map<String, Object>> getOverview() throws IOException {
        try {
            this.metricFetcher.update();
            Set<Integer> heartbeatIds = this.heartbeatManager.getHeartBeatMap().keySet();
            HashSet<Integer> activeContainerIds = new HashSet<Integer>(heartbeatIds);
            HashSet<Integer> activeDriverIds = new HashSet<Integer>(heartbeatIds);
            activeContainerIds.retainAll(this.heartbeatManager.getActiveContainerIds());
            activeDriverIds.retainAll(this.heartbeatManager.getActiveDriverIds());
            int activeContainerNum = activeContainerIds.size();
            int activeDriverNum = activeDriverIds.size();
            int totalContainerNum = this.clusterManager.getTotalContainers();
            int totalDriverNum = this.clusterManager.getTotalDrivers();
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            ret.put(TOTAL_CONTAINER_NUM, totalContainerNum);
            ret.put(TOTAL_DRIVER_NUM, totalDriverNum);
            ret.put(ACTIVE_CONTAINER_NUM, activeContainerNum);
            ret.put(ACTIVE_DRIVER_NUM, activeDriverNum);
            if (this.resourceManager instanceof DefaultResourceManager) {
                ResourceMetrics metrics = ((DefaultResourceManager)this.resourceManager).getResourceMetrics();
                ret.put(TOTAL_WORKER_NUM, metrics.getTotalWorkers());
                ret.put(AVAILABLE_WORKER_NUM, metrics.getAvailableWorkers());
                ret.put(PENDING_WORKER_NUM, metrics.getPendingWorkers());
                ret.put(USED_WORKER_NUM, metrics.getTotalWorkers() - metrics.getAvailableWorkers());
            }
            return ApiResponse.success(ret);
        }
        catch (Throwable t) {
            LOGGER.error("Query overview info failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/containers")
    @Produces(value={"application/json"})
    public ApiResponse<List<JSONObject>> getContainers() throws IOException {
        try {
            this.metricFetcher.update();
            Map<Integer, ContainerInfo> containerMap = this.clusterManager.getContainerInfos();
            Map<Integer, Heartbeat> heartbeatMap = this.heartbeatManager.getHeartBeatMap();
            Set<Integer> activeContainerIds = this.heartbeatManager.getActiveContainerIds();
            return ApiResponse.success(this.buildDetailInfo(containerMap, heartbeatMap, activeContainerIds));
        }
        catch (Throwable t) {
            LOGGER.error("Query containers failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/drivers")
    @Produces(value={"application/json"})
    public ApiResponse<List<JSONObject>> getDrivers() throws IOException {
        try {
            this.metricFetcher.update();
            Map<Integer, DriverInfo> driverMap = this.clusterManager.getDriverInfos();
            Map<Integer, Heartbeat> heartbeatMap = this.heartbeatManager.getHeartBeatMap();
            Set<Integer> activeDriverIds = this.heartbeatManager.getActiveDriverIds();
            return ApiResponse.success(this.buildDetailInfo(driverMap, heartbeatMap, activeDriverIds));
        }
        catch (Throwable t) {
            LOGGER.error("Query drivers failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    private <T extends ComponentInfo> List<JSONObject> buildDetailInfo(Map<Integer, T> componentMap, Map<Integer, Heartbeat> heartbeatMap, Set<Integer> activeComponentIds) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (Map.Entry<Integer, T> entry : componentMap.entrySet()) {
            Integer componentId = entry.getKey();
            JSONObject containerObj = new JSONObject();
            containerObj.put(CONTAINER_ID_KEY, (Object)componentId);
            ComponentInfo info = (ComponentInfo)entry.getValue();
            containerObj.put(CONTAINER_NAME_KEY, (Object)info.getName());
            containerObj.put(CONTAINER_HOST_KEY, (Object)info.getHost());
            containerObj.put(AGENT_PORT_KEY, (Object)info.getAgentPort());
            containerObj.put(PROCESS_ID_KEY, (Object)info.getPid());
            Heartbeat heartbeat = heartbeatMap.get(componentId);
            if (heartbeat != null) {
                containerObj.put(LAST_UPDATE_TIME, (Object)heartbeat.getTimestamp());
                containerObj.put(PROCESS_METRICS_KEY, (Object)heartbeat.getProcessMetrics());
            }
            containerObj.put(IS_ACTIVE, (Object)activeComponentIds.contains(componentId));
            result.add(containerObj);
        }
        return result;
    }
}

