/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.api;

import java.io.Serializable;

public class ApiResponse<T>
implements Serializable {
    private final boolean success;
    private final String message;
    private final T data;

    public ApiResponse(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public static <T> ApiResponse<T> success() {
        return new ApiResponse<Object>(true, null, null);
    }

    public static <T> ApiResponse<T> success(T data) {
        return new ApiResponse<T>(true, null, data);
    }

    public static <T> ApiResponse<T> error(String message) {
        return new ApiResponse<Object>(false, message, null);
    }

    public static <T> ApiResponse<T> error(Throwable t) {
        return ApiResponse.error(t.getMessage());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "ApiResponse{success=" + this.success + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

