/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.agent.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import org.apache.geaflow.cluster.web.agent.model.FileInfo;
import org.apache.geaflow.cluster.web.agent.model.PaginationRequest;
import org.apache.geaflow.cluster.web.agent.model.PaginationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final String NUL_CHAR = "\\u0000";

    public static PaginationResponse<String> getFileContent(PaginationRequest request, String filePath) {
        int start = (request.getPageNo() - 1) * request.getPageSize();
        File file = new File(filePath);
        if (file.exists()) {
            byte[] buf = new byte[request.getPageSize()];
            try (FileInputStream inputStream = new FileInputStream(file);){
                inputStream.skip(start);
                inputStream.read(buf);
            }
            catch (IOException e) {
                throw new RuntimeException("Error read file content.", e);
            }
            PaginationResponse<String> response = new PaginationResponse<String>();
            response.setData(new String(buf).replaceAll(NUL_CHAR, ""));
            response.setTotal(file.length());
            return response;
        }
        return null;
    }

    public static FileInfo buildFileInfo(File file, String path) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setPath(path);
        fileInfo.setSize(file.length());
        try {
            BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(Paths.get(path, new String[0]), BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            fileInfo.setCreatedTime(basicFileAttributeView.readAttributes().creationTime().toMillis());
        }
        catch (IOException e) {
            LOGGER.error("Get created time of file {} failed. {}", new Object[]{path, e.getMessage(), e});
        }
        return fileInfo;
    }

    public static void checkPaginationRequest(PaginationRequest request) {
        Preconditions.checkArgument((request.getPageNo() > 0 ? 1 : 0) != 0, (Object)"Page number should be greater than 0.");
        Preconditions.checkArgument((request.getPageSize() > 0 ? 1 : 0) != 0, (Object)"Page size should be greater than 0.");
    }
}

