/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.agent.handler;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.geaflow.cluster.web.agent.model.PaginationRequest;
import org.apache.geaflow.cluster.web.agent.model.PaginationResponse;
import org.apache.geaflow.cluster.web.agent.model.ThreadDumpRequest;
import org.apache.geaflow.cluster.web.agent.model.ThreadDumpResponse;
import org.apache.geaflow.cluster.web.agent.util.FileUtil;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.common.utils.ShellUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/thread-dump")
public class ThreadDumpRestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDumpRestHandler.class);
    private static final String THREAD_DUMP_FILE_NAME = "geaflow-thread-dump.log";
    private final String threadDumpFilePath;

    public ThreadDumpRestHandler(String agentDir) {
        this.threadDumpFilePath = Paths.get(agentDir, THREAD_DUMP_FILE_NAME).toString();
    }

    @GET
    @Path(value="/content")
    @Produces(value={"application/json"})
    public ApiResponse<PaginationResponse<ThreadDumpResponse>> getThreadDumpFileContent(@QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        try {
            PaginationRequest request = new PaginationRequest(pageNo, pageSize);
            FileUtil.checkPaginationRequest(request);
            PaginationResponse<String> response = FileUtil.getFileContent(request, this.threadDumpFilePath);
            if (response == null) {
                LOGGER.warn("Thread-dump log file {} not exists.", (Object)this.threadDumpFilePath);
                return ApiResponse.success(new PaginationResponse<Object>(0L, null));
            }
            File file = new File(this.threadDumpFilePath);
            ThreadDumpResponse threadDumpResponse = new ThreadDumpResponse();
            threadDumpResponse.setLastDumpTime(file.lastModified());
            threadDumpResponse.setContent(response.getData());
            return ApiResponse.success(new PaginationResponse<ThreadDumpResponse>(response.getTotal(), threadDumpResponse));
        }
        catch (Throwable t) {
            LOGGER.error("Query thread-dump log content failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ApiResponse<Void> executeThreadDumpProfiler(ThreadDumpRequest request) {
        try {
            this.checkThreadDumpRequest(request);
            ProcessBuilder command = this.getCommand(request.getPid());
            ShellUtil.executeShellCommand((ProcessBuilder)command, (int)30);
            return ApiResponse.success();
        }
        catch (Throwable t) {
            LOGGER.error("Execute thread-dump command failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    private void checkThreadDumpRequest(ThreadDumpRequest request) {
        Preconditions.checkArgument((request.getPid() > 0 ? 1 : 0) != 0, (Object)"Pid must be larger than 0.");
    }

    private ProcessBuilder getCommand(int pid) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("sh");
        commands.add("-c");
        commands.add(String.format("jstack -l %d > %s", pid, this.threadDumpFilePath));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commands);
        return processBuilder;
    }
}

