/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.agent.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.geaflow.cluster.web.agent.model.FileInfo;
import org.apache.geaflow.cluster.web.agent.model.PaginationRequest;
import org.apache.geaflow.cluster.web.agent.model.PaginationResponse;
import org.apache.geaflow.cluster.web.agent.util.FileUtil;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/logs")
public class LogRestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogRestHandler.class);
    private final String runtimeLogDirPath;
    private final Pattern logPattern;

    public LogRestHandler(String runtimeLogDirPath) {
        this.runtimeLogDirPath = runtimeLogDirPath;
        this.logPattern = Pattern.compile(String.format("%s.*\\.log(\\.\\d*)?", this.runtimeLogDirPath));
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public ApiResponse<List<FileInfo>> getLogList() {
        try {
            String[] fileList;
            this.checkRuntimeLogDirPath();
            ArrayList<FileInfo> logs = new ArrayList<FileInfo>();
            File file = new File(this.runtimeLogDirPath);
            for (String f : fileList = file.list()) {
                String logPath = this.runtimeLogDirPath + File.separator + f;
                File logFile = new File(logPath);
                if (!logFile.isFile() || !this.logPattern.matcher(logPath).matches()) continue;
                FileInfo fileInfo = FileUtil.buildFileInfo(logFile, logPath);
                logs.add(fileInfo);
            }
            return ApiResponse.success(logs);
        }
        catch (Throwable t) {
            LOGGER.error("Query log file list failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/content")
    @Produces(value={"application/json"})
    public ApiResponse<PaginationResponse<String>> getLogContent(@QueryParam(value="path") String logPath, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        try {
            this.checkLogPath(logPath);
            PaginationRequest request = new PaginationRequest(pageNo, pageSize);
            FileUtil.checkPaginationRequest(request);
            PaginationResponse<String> response = FileUtil.getFileContent(request, logPath);
            if (response == null) {
                throw new GeaflowRuntimeException(String.format("Log file %s not exists.", logPath));
            }
            return ApiResponse.success(response);
        }
        catch (Throwable t) {
            LOGGER.error("Query log content {} failed. {}", new Object[]{logPath, t.getMessage(), t});
            return ApiResponse.error(t);
        }
    }

    private void checkRuntimeLogDirPath() {
        if (StringUtils.isEmpty((CharSequence)this.runtimeLogDirPath)) {
            throw new GeaflowRuntimeException(String.format("Log dir path is not set. Please set the log dir path config: %s", ExecutionConfigKeys.LOG_DIR.getKey()));
        }
    }

    private void checkLogPath(String logPath) {
        if (logPath == null || !this.logPattern.matcher(logPath).matches()) {
            throw new GeaflowRuntimeException(String.format("Log path %s is invalid.", logPath));
        }
    }
}

