/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.agent.handler;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geaflow.cluster.web.agent.model.FileInfo;
import org.apache.geaflow.cluster.web.agent.model.FlameGraphRequest;
import org.apache.geaflow.cluster.web.agent.model.FlameGraphType;
import org.apache.geaflow.cluster.web.agent.util.DateUtil;
import org.apache.geaflow.cluster.web.agent.util.FileUtil;
import org.apache.geaflow.cluster.web.api.ApiResponse;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.common.utils.ShellUtil;
import org.apache.geaflow.common.utils.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/flame-graphs")
public class FlameGraphRestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlameGraphRestHandler.class);
    private static final String FLAME_GRAPH_FILE_PREFIX = "geaflow-flamegraph";
    private static final int FLAME_GRAPH_FILE_MAX_CNT = 10;
    private final ExecutorService profileService = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), ThreadUtil.namedThreadFactory((boolean)true, (String)"flame-graph-profiler"));
    private final String flameGraphProfilerPath;
    private final String flameGraphFileNameExtension;
    private final String agentDir;

    public FlameGraphRestHandler(String flameGraphProfilerPath, String flameGraphFileNameExtension, String agentDir) {
        this.flameGraphProfilerPath = flameGraphProfilerPath;
        this.flameGraphFileNameExtension = flameGraphFileNameExtension;
        this.agentDir = agentDir;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public ApiResponse<List<FileInfo>> getFlameGraphFileList() {
        try {
            ArrayList<FileInfo> flameGraphFiles = new ArrayList<FileInfo>();
            File file = new File(this.agentDir);
            String[] fileList = file.list();
            if (fileList != null) {
                for (String f : fileList) {
                    String filePath = this.agentDir + File.separator + f;
                    File flameGraphFile = new File(filePath);
                    if (!flameGraphFile.isFile() || !f.startsWith(FLAME_GRAPH_FILE_PREFIX) || !f.endsWith(this.flameGraphFileNameExtension)) continue;
                    FileInfo fileInfo = FileUtil.buildFileInfo(flameGraphFile, filePath);
                    flameGraphFiles.add(fileInfo);
                }
            }
            return ApiResponse.success(flameGraphFiles);
        }
        catch (Throwable t) {
            LOGGER.error("Query flame-graph file list failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @GET
    @Path(value="/content")
    @Produces(value={"application/json"})
    public ApiResponse<String> getFlameGraphFileContent(@QueryParam(value="path") String filePath) {
        try {
            this.checkFlameGraphFilePath(filePath);
            String content = org.apache.geaflow.common.utils.FileUtil.getContentFromFile((String)filePath);
            if (content == null) {
                throw new GeaflowRuntimeException(String.format("Flame-graph file %s not exists.", filePath));
            }
            return ApiResponse.success(content);
        }
        catch (Throwable t) {
            LOGGER.error("Query flame-graph file content failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ApiResponse<Void> executeFlameGraphProfiler(FlameGraphRequest request) {
        try {
            this.checkProfilerPath();
            this.checkFlameGraphRequest(request);
            this.checkFlameGraphFileCount();
            ProcessBuilder command = this.getCommand(request);
            this.profileService.submit(() -> ShellUtil.executeShellCommand((ProcessBuilder)command, (int)90));
            return ApiResponse.success();
        }
        catch (Throwable t) {
            LOGGER.error("Execute flame-graph profiler command failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public ApiResponse<Void> deleteFlameGraphFile(@QueryParam(value="path") String filePath) {
        try {
            this.checkFlameGraphFilePath(filePath);
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) {
                throw new GeaflowRuntimeException(String.format("File %s not found.", filePath));
            }
            file.delete();
            return ApiResponse.success();
        }
        catch (Throwable t) {
            LOGGER.error("Delete flame-graph file failed. {}", (Object)t.getMessage(), (Object)t);
            return ApiResponse.error(t);
        }
    }

    private void checkFlameGraphFileCount() {
        File file = new File(this.agentDir);
        String[] fileList = file.list();
        int cnt = 0;
        if (fileList != null) {
            for (String f : fileList) {
                String filePath = this.agentDir + File.separator + f;
                File flameGraphFile = new File(filePath);
                if (!flameGraphFile.isFile() || !f.startsWith(FLAME_GRAPH_FILE_PREFIX) || !f.endsWith(this.flameGraphFileNameExtension)) continue;
                ++cnt;
            }
        }
        if (cnt >= 10) {
            throw new GeaflowRuntimeException(String.format("The count of flame-graph files is limited to %s. Please delete some of them first.", 10));
        }
    }

    private void checkProfilerPath() {
        if (StringUtils.isEmpty((CharSequence)this.flameGraphProfilerPath)) {
            throw new GeaflowRuntimeException(String.format("Async-profiler shell script path is not set. Please set the file path of async-profiler path: %s", "AGENT_PROFILER_PATH"));
        }
    }

    private void checkFlameGraphFilePath(String path) {
        Preconditions.checkArgument((path != null && path.startsWith(this.agentDir) && path.endsWith(this.flameGraphFileNameExtension) ? 1 : 0) != 0, (Object)"File path is invalid.");
    }

    private void checkFlameGraphRequest(FlameGraphRequest request) {
        Preconditions.checkArgument((request.getType() != null ? 1 : 0) != 0, (Object)"Profiler type cannot be null.");
        Preconditions.checkArgument((request.getDuration() > 0 && request.getDuration() <= 60 ? 1 : 0) != 0, (Object)"Duration must be within 0~60 seconds.");
        Preconditions.checkArgument((request.getPid() > 0 ? 1 : 0) != 0, (Object)"Pid must be larger than 0.");
    }

    private ProcessBuilder getCommand(FlameGraphRequest request) {
        String now = DateUtil.simpleFormat(System.currentTimeMillis());
        String randomSuffix = RandomStringUtils.randomAlphabetic((int)4);
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.agentDir).append("/").append(FLAME_GRAPH_FILE_PREFIX).append("-").append("pid").append(request.getPid()).append("-").append((Object)request.getType()).append("-").append(request.getDuration()).append("s").append("-").append(now).append("-").append(randomSuffix).append(this.flameGraphFileNameExtension);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("sh");
        commands.add(this.flameGraphProfilerPath);
        commands.add("--all-user");
        commands.add("-d");
        commands.add(String.valueOf(request.getDuration()));
        if (request.getType() == FlameGraphType.ALLOC) {
            commands.add("-e");
            commands.add(FlameGraphType.ALLOC.name().toLowerCase());
        }
        commands.add("-f");
        commands.add(filePath.toString());
        commands.add(String.valueOf(request.getPid()));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commands);
        return processBuilder;
    }
}

