/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web.agent;

import javax.servlet.Servlet;
import org.apache.geaflow.cluster.web.agent.handler.FlameGraphRestHandler;
import org.apache.geaflow.cluster.web.agent.handler.LogRestHandler;
import org.apache.geaflow.cluster.web.agent.handler.ThreadDumpRestHandler;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentWebServer.class);
    private static final String AGENT_SERVER_NAME = "agent-jetty-server";
    private static final int DEFAULT_ACCEPT_QUEUE_SIZE = 8;
    private final Server server;
    private final int httpPort;
    private final QueuedThreadPool threadPool;
    private final ScheduledExecutorScheduler serverExecutor;
    private final Object lock = new Object();

    public AgentWebServer(int httpPort, Configuration configuration) {
        this(httpPort, configuration.getString(ExecutionConfigKeys.LOG_DIR), configuration.getString("AGENT_PROFILER_PATH"), configuration.getString(ExecutionConfigKeys.PROFILER_FILENAME_EXTENSION), configuration.getString(ExecutionConfigKeys.JOB_WORK_PATH));
    }

    public AgentWebServer(int httpPort, String runtimeLogDirPath, String flameGraphProfilerPath, String flameGraphFileNameExtension, String agentDir) {
        this.httpPort = httpPort;
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setDaemon(true);
        this.threadPool.setName(AGENT_SERVER_NAME);
        this.server = new Server((ThreadPool)this.threadPool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(this.server);
        this.server.addBean((Object)errorHandler);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new LogRestHandler(runtimeLogDirPath));
        resourceConfig.register((Object)new FlameGraphRestHandler(flameGraphProfilerPath, flameGraphFileNameExtension, agentDir));
        resourceConfig.register((Object)new ThreadDumpRestHandler(agentDir));
        ServletContextHandler handler = new ServletContextHandler(0);
        handler.setContextPath("/");
        handler.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/rest/*");
        handler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/");
        this.server.setHandler((Handler)handler);
        this.serverExecutor = new ScheduledExecutorScheduler("jetty-scheduler", true);
    }

    public void start() {
        try {
            ServerConnector connector = this.newConnector(this.server, this.serverExecutor, null, this.httpPort);
            connector.setName(AGENT_SERVER_NAME);
            this.server.addConnector((Connector)connector);
            int minThreads = 1;
            this.threadPool.setMaxThreads(Math.max(this.threadPool.getMaxThreads(), minThreads += connector.getAcceptors() * 2));
            this.server.start();
            LOGGER.info("Jetty Server started: {}.", (Object)this.httpPort);
        }
        catch (Exception e) {
            LOGGER.error("Jetty server failed.", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        LOGGER.info("Wait for agent jetty server stopped.");
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.server.stop();
            if (this.threadPool.isStarted()) {
                this.threadPool.stop();
            }
            if (this.serverExecutor.isStarted()) {
                this.serverExecutor.stop();
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Stop jetty server failed.", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    private ServerConnector newConnector(Server server, ScheduledExecutorScheduler serverExecutor, String hostName, int port) throws Exception {
        ConnectionFactory[] connectionFactories = new ConnectionFactory[]{new HttpConnectionFactory()};
        ServerConnector connector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, connectionFactories);
        connector.setHost(hostName);
        connector.setPort(port);
        connector.start();
        connector.setAcceptQueueSize(Math.min(connector.getAcceptors(), 8));
        return connector;
    }
}

