/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.web;

import java.net.URL;
import javax.servlet.Servlet;
import org.apache.geaflow.cluster.clustermanager.IClusterManager;
import org.apache.geaflow.cluster.common.ComponentInfo;
import org.apache.geaflow.cluster.heartbeat.HeartbeatManager;
import org.apache.geaflow.cluster.resourcemanager.IResourceManager;
import org.apache.geaflow.cluster.web.handler.ClusterRestHandler;
import org.apache.geaflow.cluster.web.handler.MasterRestHandler;
import org.apache.geaflow.cluster.web.handler.PipelineRestHandler;
import org.apache.geaflow.cluster.web.handler.ProxyHandler;
import org.apache.geaflow.cluster.web.metrics.MetricFetcher;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.stats.model.MetricCache;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private static final String SERVER_NAME = "jetty-server";
    private static final int DEFAULT_ACCEPT_QUEUE_SIZE = 8;
    private static final int HTTP_NOTFOUND_CODE = 404;
    private static final String STATIC_RESOURCES_FOLDER_PATH = "dist";
    private final Server server;
    private final int httpPort;
    private final QueuedThreadPool threadPool;
    private final ScheduledExecutorScheduler serverExecutor;

    public HttpServer(Configuration configuration, IClusterManager clusterManager, HeartbeatManager heartbeatManager, IResourceManager resourceManager, ComponentInfo masterInfo) {
        this.httpPort = configuration.getInteger(ExecutionConfigKeys.MASTER_HTTP_PORT);
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setDaemon(true);
        this.threadPool.setName(SERVER_NAME);
        this.server = new Server((ThreadPool)this.threadPool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(this.server);
        this.server.addBean((Object)errorHandler);
        MetricCache metricCache = new MetricCache();
        MetricFetcher metricFetcher = new MetricFetcher(configuration, clusterManager, metricCache);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new MasterRestHandler(masterInfo, configuration));
        resourceConfig.register((Object)new ClusterRestHandler(clusterManager, heartbeatManager, resourceManager, metricFetcher));
        resourceConfig.register((Object)new PipelineRestHandler(metricCache, metricFetcher));
        ServletContextHandler handler = new ServletContextHandler(0);
        handler.setContextPath("/");
        handler.addServlet(new ServletHolder((Servlet)new ProxyHandler()), "/proxy/*");
        handler.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/rest/*");
        handler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/");
        try {
            URL resourcePath = HttpServer.class.getClassLoader().getResource(STATIC_RESOURCES_FOLDER_PATH);
            LOGGER.info("Try Loading static resources of path: {}", (Object)resourcePath);
            handler.setBaseResource(Resource.newResource((URL)resourcePath));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load static resources. {}", (Object)e.getMessage(), (Object)e);
        }
        ErrorPageErrorHandler errorPageHandler = new ErrorPageErrorHandler();
        errorPageHandler.addErrorPage(404, "/");
        handler.setErrorHandler((ErrorHandler)errorPageHandler);
        this.server.setHandler((Handler)handler);
        this.serverExecutor = new ScheduledExecutorScheduler("jetty-scheduler", true);
    }

    public void start() {
        try {
            ServerConnector connector = this.newConnector(this.server, this.serverExecutor, null, this.httpPort);
            connector.setName(SERVER_NAME);
            this.server.addConnector((Connector)connector);
            int minThreads = 1;
            this.threadPool.setMaxThreads(Math.max(this.threadPool.getMaxThreads(), minThreads += connector.getAcceptors() * 2));
            this.server.start();
            LOGGER.info("Jetty Server started: {}", (Object)this.httpPort);
        }
        catch (Exception e) {
            LOGGER.error("jetty server failed:", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
            if (this.threadPool.isStarted()) {
                this.threadPool.stop();
            }
            if (this.serverExecutor.isStarted()) {
                this.serverExecutor.stop();
            }
        }
        catch (Exception e) {
            LOGGER.warn("stop jetty server failed", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    private ServerConnector newConnector(Server server, ScheduledExecutorScheduler serverExecutor, String hostName, int port) throws Exception {
        ConnectionFactory[] connectionFactories = new ConnectionFactory[]{new HttpConnectionFactory()};
        ServerConnector connector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, connectionFactories);
        connector.setHost(hostName);
        connector.setPort(port);
        connector.start();
        connector.setAcceptQueueSize(Math.min(connector.getAcceptors(), 8));
        return connector;
    }
}

