/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.task.service;

import org.apache.geaflow.cluster.collector.EmitterService;
import org.apache.geaflow.cluster.fetcher.FetcherService;
import org.apache.geaflow.cluster.protocol.ICommand;
import org.apache.geaflow.cluster.task.runner.TaskRunner;
import org.apache.geaflow.cluster.task.runner.TaskRunnerContext;
import org.apache.geaflow.cluster.task.service.AbstractTaskService;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.metrics.common.api.MetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskService
extends AbstractTaskService<ICommand, TaskRunner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskService.class);
    private static final String WORKER_FORMAT = "geaflow-worker-%d";
    private int containerId;
    private int taskNum;
    private MetricGroup metricGroup;
    private FetcherService fetcherService;
    private EmitterService emitterService;

    public TaskService(int containerId, int taskNum, Configuration configuration, MetricGroup metricGroup, FetcherService fetcherService, EmitterService emitterService) {
        super(configuration, WORKER_FORMAT);
        this.containerId = containerId;
        this.taskNum = taskNum;
        this.metricGroup = metricGroup;
        this.fetcherService = fetcherService;
        this.emitterService = emitterService;
    }

    protected TaskRunner[] buildTaskRunner() {
        TaskRunner[] taskRunners = new TaskRunner[this.taskNum];
        for (int i = 0; i < this.taskNum; ++i) {
            TaskRunner taskRunner;
            taskRunners[i] = taskRunner = this.buildTask(this.containerId, i, this.configuration, this.metricGroup, this.fetcherService, this.emitterService);
        }
        return taskRunners;
    }

    private TaskRunner buildTask(int containerId, int taskIndex, Configuration configuration, MetricGroup metricGroup, FetcherService fetcherService, EmitterService emitterService) {
        TaskRunner taskRunner = new TaskRunner();
        TaskRunnerContext taskRunnerContext = new TaskRunnerContext(containerId, taskIndex, configuration, metricGroup, fetcherService, emitterService);
        taskRunner.init(taskRunnerContext);
        return taskRunner;
    }
}

