/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.system;

import org.apache.geaflow.cluster.system.IClusterMetaKVStore;
import org.apache.geaflow.state.DataModel;
import org.apache.geaflow.state.StoreType;
import org.apache.geaflow.store.IStoreBuilder;
import org.apache.geaflow.store.api.StoreBuilderFactory;
import org.apache.geaflow.store.api.key.IKVStatefulStore;
import org.apache.geaflow.store.context.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbClusterMetaKVStore<K, V>
implements IClusterMetaKVStore<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksdbClusterMetaKVStore.class);
    private static final Integer DEFAULT_VERSION = 1;
    private IKVStatefulStore<K, Object> kvStore;
    private transient long version;
    private String name;

    @Override
    public void init(StoreContext storeContext) {
        IStoreBuilder builder = StoreBuilderFactory.build((String)StoreType.ROCKSDB.name());
        this.name = storeContext.getName();
        this.kvStore = (IKVStatefulStore)builder.getStore(DataModel.KV, storeContext.getConfig());
        this.kvStore.init(storeContext);
        long latest = this.kvStore.recoveryLatest();
        if (latest > 0L) {
            LOGGER.info("recovery to latest version {}", (Object)latest);
            this.version = latest + 1L;
        } else {
            LOGGER.info("not found any version to recovery");
            this.version = DEFAULT_VERSION.intValue();
        }
    }

    @Override
    public void flush() {
        LOGGER.info("cluster meta {} do flush", (Object)this.name);
        this.kvStore.archive(this.version);
        ++this.version;
    }

    public V get(K key) {
        return (V)this.kvStore.get(key);
    }

    public void put(K key, V value) {
        this.kvStore.put(key, value);
    }

    public void remove(K key) {
        this.kvStore.remove(key);
    }

    @Override
    public void close() {
        this.kvStore.close();
    }
}

