/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.system;

import org.apache.geaflow.cluster.system.IClusterMetaKVStore;
import org.apache.geaflow.state.DataModel;
import org.apache.geaflow.state.StoreType;
import org.apache.geaflow.store.IStoreBuilder;
import org.apache.geaflow.store.api.StoreBuilderFactory;
import org.apache.geaflow.store.api.key.IKVStore;
import org.apache.geaflow.store.context.StoreContext;

public class MemoryClusterMetaKVStore<V>
implements IClusterMetaKVStore<String, V> {
    private IKVStore<String, Object> kvStore;

    @Override
    public void init(StoreContext storeContext) {
        IStoreBuilder builder = StoreBuilderFactory.build((String)StoreType.MEMORY.name());
        this.kvStore = (IKVStore)builder.getStore(DataModel.KV, storeContext.getConfig());
    }

    @Override
    public void flush() {
    }

    public V get(String key) {
        return (V)this.kvStore.get((Object)key);
    }

    public void put(String key, V value) {
        this.kvStore.put((Object)key, value);
    }

    public void remove(String key) {
        this.kvStore.remove((Object)key);
    }

    @Override
    public void close() {
        this.kvStore.close();
    }
}

