/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.system;

import org.apache.geaflow.cluster.system.IClusterMetaKVStore;
import org.apache.geaflow.cluster.system.MemoryClusterMetaKVStore;
import org.apache.geaflow.cluster.system.RocksdbClusterMetaKVStore;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.FrameworkConfigKeys;
import org.apache.geaflow.state.StoreType;
import org.apache.geaflow.state.serializer.DefaultKVSerializer;
import org.apache.geaflow.state.serializer.IKeySerializer;
import org.apache.geaflow.store.context.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetaStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMetaStoreFactory.class);
    private static final int DEFAULT_SHARD_ID = 0;

    public static <K, V> IClusterMetaKVStore<K, V> create(String name, Configuration configuration) {
        return ClusterMetaStoreFactory.create(name, 0, configuration);
    }

    public static <K, V> IClusterMetaKVStore<K, V> create(String name, int shardId, Configuration configuration) {
        StoreContext storeContext = new StoreContext(name);
        storeContext.withKeySerializer((IKeySerializer)new DefaultKVSerializer(null, null));
        storeContext.withConfig(configuration);
        storeContext.withShardId(shardId);
        String backendType = configuration.getString(FrameworkConfigKeys.SYSTEM_STATE_BACKEND_TYPE);
        IClusterMetaKVStore<K, V> store = ClusterMetaStoreFactory.create(StoreType.getEnum((String)backendType));
        store.init(storeContext);
        return store;
    }

    private static <K, V> IClusterMetaKVStore<K, V> create(StoreType storeType) {
        IClusterMetaKVStore clusterMetaKVStore;
        switch (storeType) {
            case ROCKSDB: {
                LOGGER.info("create rocksdb cluster metastore");
                clusterMetaKVStore = new RocksdbClusterMetaKVStore();
                break;
            }
            default: {
                LOGGER.info("create memory cluster metastore");
                clusterMetaKVStore = new MemoryClusterMetaKVStore();
            }
        }
        return clusterMetaKVStore;
    }
}

