/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.system;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.cluster.resourcemanager.WorkerSnapshot;
import org.apache.geaflow.cluster.system.ClusterMetaStoreFactory;
import org.apache.geaflow.cluster.system.IClusterMetaKVStore;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.pipeline.Pipeline;
import org.apache.geaflow.store.context.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetaStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMetaStore.class);
    private static final String CLUSTER_META_NAMESPACE_LABEL = "framework";
    private static final String CLUSTER_NAMESPACE_PREFIX = "cluster";
    private static final String OFFSET_NAMESPACE = "offset";
    private static ClusterMetaStore INSTANCE;
    private final int componentId;
    private final String componentName;
    private final String clusterId;
    private final Configuration configuration;
    private final IClusterMetaKVStore<String, Object> componentBackend;
    private Map<String, IClusterMetaKVStore<String, Object>> backends;

    private ClusterMetaStore(int id, String name, Configuration configuration) {
        this.componentId = id;
        this.componentName = name;
        this.configuration = configuration;
        this.backends = new ConcurrentHashMap<String, IClusterMetaKVStore<String, Object>>();
        this.clusterId = configuration.getString(ExecutionConfigKeys.CLUSTER_ID);
        String namespace = String.format("%s/%s/%s", CLUSTER_NAMESPACE_PREFIX, this.clusterId, this.componentName);
        this.componentBackend = this.createBackend(namespace);
        this.backends.put(namespace, this.componentBackend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(int id, String name, Configuration configuration) {
        if (INSTANCE != null) return;
        Class<ClusterMetaStore> clazz = ClusterMetaStore.class;
        synchronized (ClusterMetaStore.class) {
            if (INSTANCE != null) return;
            INSTANCE = new ClusterMetaStore(id, name, configuration);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static ClusterMetaStore getInstance(int id, String name, Configuration configuration) {
        if (INSTANCE == null) {
            ClusterMetaStore.init(id, name, configuration);
        }
        return INSTANCE;
    }

    public static ClusterMetaStore getInstance() {
        return INSTANCE;
    }

    public static synchronized void close() {
        LOGGER.info("close ClusterMetaStore");
        if (INSTANCE != null) {
            Map<String, IClusterMetaKVStore<String, Object>> backends = ClusterMetaStore.INSTANCE.backends;
            ClusterMetaStore.INSTANCE.backends = null;
            for (IClusterMetaKVStore<String, Object> backend : backends.values()) {
                backend.close();
            }
            INSTANCE = null;
        }
    }

    public ClusterMetaStore savePipeline(Pipeline pipeline) {
        this.save(ClusterMetaKey.PIPELINE, pipeline);
        return this;
    }

    public ClusterMetaStore savePipelineTaskIds(List<Long> pipelineTaskIds) {
        this.save(ClusterMetaKey.PIPELINE_TASK_IDS, pipelineTaskIds);
        return this;
    }

    public ClusterMetaStore savePipelineTasks(List<Integer> taskIndices) {
        this.save(ClusterMetaKey.PIPELINE_TASKS, taskIndices);
        return this;
    }

    public void saveWindowId(Long windowId, long pipelineTaskId) {
        this.save(ClusterMetaKey.WINDOW_ID, windowId, pipelineTaskId);
    }

    public ClusterMetaStore saveCycle(Object cycle, long pipelineTaskId) {
        this.save(ClusterMetaKey.CYCLE, cycle, pipelineTaskId);
        return this;
    }

    public ClusterMetaStore saveEvent(List<IEvent> event) {
        this.save(ClusterMetaKey.EVENTS, event);
        return this;
    }

    public void saveWorkers(WorkerSnapshot workers) {
        this.save(ClusterMetaKey.WORKERS, workers);
    }

    public ClusterMetaStore saveContainerIds(Map<Integer, String> containerIds) {
        this.save(ClusterMetaKey.CONTAINER_IDS, containerIds);
        return this;
    }

    public ClusterMetaStore saveDriverIds(Map<Integer, String> driverIds) {
        this.save(ClusterMetaKey.DRIVER_IDS, driverIds);
        return this;
    }

    public ClusterMetaStore saveMaxContainerId(int containerId) {
        this.save(ClusterMetaKey.MAX_CONTAINER_ID, containerId);
        return this;
    }

    public Pipeline getPipeline() {
        return (Pipeline)this.get(ClusterMetaKey.PIPELINE);
    }

    public List<Long> getPipelineTaskIds() {
        return (List)this.get(ClusterMetaKey.PIPELINE_TASK_IDS);
    }

    public List<Integer> getPipelineTasks() {
        return (List)this.get(ClusterMetaKey.PIPELINE_TASKS);
    }

    public Long getWindowId(long pipelineTaskId) {
        return (Long)this.get(ClusterMetaKey.WINDOW_ID, pipelineTaskId);
    }

    public Object getCycle(long pipelineTaskId) {
        return this.get(ClusterMetaKey.CYCLE, pipelineTaskId);
    }

    public List<IEvent> getEvents() {
        return (List)this.get(ClusterMetaKey.EVENTS);
    }

    public WorkerSnapshot getWorkers() {
        return (WorkerSnapshot)this.get(ClusterMetaKey.WORKERS);
    }

    public int getMaxContainerId() {
        return (Integer)this.get(ClusterMetaKey.MAX_CONTAINER_ID);
    }

    public Map<Integer, String> getContainerIds() {
        return (Map)this.get(ClusterMetaKey.CONTAINER_IDS);
    }

    public Map<Integer, String> getDriverIds() {
        return (Map)this.get(ClusterMetaKey.DRIVER_IDS);
    }

    public void flush() {
        this.componentBackend.flush();
    }

    public void clean() {
    }

    private <T> void save(ClusterMetaKey key, T value) {
        this.getBackend(key).put(key.name(), value);
    }

    private <T> void save(ClusterMetaKey key, T value, long pipelineTaskId) {
        this.getBackend(key).put(this.getKeyTag(key.name(), pipelineTaskId), value);
    }

    private <T> T get(ClusterMetaKey key) {
        return (T)this.getBackend(key).get(key.name());
    }

    private <T> T get(ClusterMetaKey key, long pipelineTaskId) {
        return (T)this.getBackend(key).get(this.getKeyTag(key.name(), pipelineTaskId));
    }

    private String getKeyTag(String key, long pipelineTaskId) {
        return String.format("%s#%s", key, pipelineTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IClusterMetaKVStore<String, Object> getBackend(ClusterMetaKey metaKey) {
        String namespace;
        switch (metaKey) {
            case WORKERS: {
                namespace = String.format("%s/%s/%s", CLUSTER_NAMESPACE_PREFIX, this.clusterId, metaKey.name().toLowerCase());
                break;
            }
            case WINDOW_ID: {
                namespace = OFFSET_NAMESPACE;
                break;
            }
            default: {
                return this.componentBackend;
            }
        }
        if (this.backends == null) {
            return null;
        }
        if (this.backends.containsKey(namespace)) return this.backends.get(namespace);
        Class<ClusterMetaStore> clazz = ClusterMetaStore.class;
        synchronized (ClusterMetaStore.class) {
            if (this.backends.containsKey(namespace)) return this.backends.get(namespace);
            IClusterMetaKVStore<String, Object> backend = this.createBackend(namespace);
            this.backends.put(namespace, new ClusterMetaKVStoreProxy<String, Object>(backend));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.backends.get(namespace);
        }
    }

    private IClusterMetaKVStore<String, Object> createBackend(String namespace) {
        String storeKey = String.format("%s/%s", CLUSTER_META_NAMESPACE_LABEL, namespace);
        IClusterMetaKVStore<String, Object> backend = ClusterMetaStoreFactory.create(storeKey, this.componentId, this.configuration);
        LOGGER.info("create ClusterMetaStore, store key {}, id {}", (Object)storeKey, (Object)this.componentId);
        return backend;
    }

    private class ClusterMetaKVStoreProxy<K, V>
    implements IClusterMetaKVStore<K, V> {
        private IClusterMetaKVStore<K, V> store;

        public ClusterMetaKVStoreProxy(IClusterMetaKVStore<K, V> store) {
            this.store = store;
        }

        @Override
        public void init(StoreContext storeContext) {
            this.store.init(storeContext);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.store.close();
        }

        public V get(K key) {
            return (V)this.store.get(key);
        }

        public void put(K key, V value) {
            this.store.put(key, value);
            this.store.flush();
        }

        public void remove(K key) {
            this.store.remove(key);
        }
    }

    public static enum ClusterMetaKey {
        PIPELINE,
        PIPELINE_TASK_IDS,
        PIPELINE_TASKS,
        WINDOW_ID,
        CYCLE,
        EVENTS,
        WORKERS,
        CONTAINER_IDS,
        DRIVER_IDS,
        MAX_CONTAINER_ID;

    }
}

