/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.runner;

import com.baidu.brpc.server.RpcServerOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.geaflow.cluster.rpc.impl.RpcServiceImpl;
import org.apache.geaflow.cluster.rpc.impl.SupervisorEndpoint;
import org.apache.geaflow.cluster.runner.CommandRunner;
import org.apache.geaflow.cluster.web.agent.AgentWebServer;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.rpc.ConfigurableServerOption;
import org.apache.geaflow.common.utils.PortUtil;
import org.apache.geaflow.common.utils.RetryCommand;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.apache.geaflow.stats.model.ExceptionLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Supervisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Supervisor.class);
    private static final int DEFAULT_RETRIES = 3;
    private final RpcServiceImpl rpcService;
    private final CommandRunner mainRunner;
    private final Configuration configuration;
    private final int maxRestarts;
    private final Map<String, String> envMap;

    public Supervisor(String startCommand, Configuration configuration, boolean autoRestart) {
        this.configuration = configuration;
        this.maxRestarts = autoRestart ? configuration.getInteger(ExecutionConfigKeys.FO_MAX_RESTARTS) : 0;
        RpcServerOptions serverOptions = this.getServerOptions(configuration);
        int port = PortUtil.getPort((int)configuration.getInteger(ExecutionConfigKeys.SUPERVISOR_RPC_PORT));
        this.rpcService = new RpcServiceImpl(port, serverOptions);
        this.rpcService.addEndpoint(new SupervisorEndpoint(this));
        this.rpcService.startService();
        this.envMap = new HashMap<String, String>();
        this.envMap.put("SUPERVISOR_PORT", String.valueOf(port));
        this.mainRunner = new CommandRunner(startCommand, this.maxRestarts, this.envMap, configuration);
        LOGGER.info("Start supervisor with maxRestarts: {}", (Object)this.maxRestarts);
    }

    private RpcServerOptions getServerOptions(Configuration configuration) {
        RpcServerOptions serverOptions = ConfigurableServerOption.build((Configuration)configuration);
        serverOptions.setGlobalThreadPoolSharing(false);
        serverOptions.setIoThreadNum(1);
        serverOptions.setWorkThreadNum(2);
        return serverOptions;
    }

    public void start() {
        try {
            this.startAgent();
            this.startWorker();
        }
        catch (Throwable e) {
            StatsCollectorFactory.init((Configuration)this.configuration).getExceptionCollector().reportException(ExceptionLevel.FATAL, e);
            throw e;
        }
    }

    public void restartWorker(int pid) {
        LOGGER.info("Restart worker process: {}", (Object)pid);
        this.stopWorker(pid);
        this.startWorker();
    }

    public void startWorker() {
        this.mainRunner.asyncStart();
    }

    public boolean isWorkerAlive() {
        Process process = this.mainRunner.getProcess();
        if (this.maxRestarts > 0 || process != null && process.isAlive()) {
            return true;
        }
        LOGGER.warn("Worker process {} is dead.", (Object)this.mainRunner.getProcessId());
        return false;
    }

    public void stopWorker() {
        this.mainRunner.stop();
    }

    public void stopWorker(int pid) {
        this.mainRunner.stop(pid);
    }

    public void startAgent() {
        RetryCommand.run(() -> {
            int agentPort = PortUtil.getPort((int)this.configuration.getInteger(ExecutionConfigKeys.AGENT_HTTP_PORT));
            this.envMap.put("AGENT_PORT", String.valueOf(agentPort));
            AgentWebServer server = new AgentWebServer(agentPort, this.configuration);
            server.start();
            return null;
        }, (int)3);
    }

    public void waitForTermination() {
        if (this.rpcService != null) {
            this.rpcService.waitTermination();
        }
    }

    public void stop() {
        if (this.rpcService != null) {
            this.rpcService.stopService();
        }
    }
}

