/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import com.google.protobuf.Empty;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.geaflow.cluster.rpc.IAsyncSupervisorEndpoint;
import org.apache.geaflow.cluster.rpc.ISupervisorEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcUtil;
import org.apache.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.rpc.proto.Supervisor;

public class SupervisorEndpointRef
extends AbstractRpcEndpointRef
implements ISupervisorEndpointRef {
    private IAsyncSupervisorEndpoint supervisorEndpoint;
    private final Empty empty = Empty.newBuilder().build();

    public SupervisorEndpointRef(String host, int port, Configuration configuration) {
        super(host, port, configuration);
    }

    @Override
    protected void getRpcEndpoint() {
        this.supervisorEndpoint = (IAsyncSupervisorEndpoint)BrpcProxy.getProxy((RpcClient)this.rpcClient, IAsyncSupervisorEndpoint.class);
    }

    @Override
    protected RpcClientOptions getClientOptions() {
        RpcClientOptions options = super.getClientOptions();
        options.setGlobalThreadPoolSharing(false);
        options.setMaxTotalConnections(2);
        options.setMinIdleConnections(2);
        options.setIoThreadNum(1);
        options.setWorkThreadNum(2);
        options.setLoadBalanceType(1);
        return options;
    }

    @Override
    public Future<Empty> restart(int pid, RpcEndpointRef.RpcCallback<Empty> callback) {
        CompletableFuture<Empty> result = new CompletableFuture<Empty>();
        RpcCallback<Empty> rpcCallback = RpcUtil.buildRpcCallback(callback, result);
        Supervisor.RestartRequest request = Supervisor.RestartRequest.newBuilder().setPid(pid).build();
        this.supervisorEndpoint.restart(request, rpcCallback);
        return result;
    }

    @Override
    public Supervisor.StatusResponse status() {
        return this.supervisorEndpoint.status(this.empty);
    }
}

