/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.server.RpcServer;
import com.baidu.brpc.server.RpcServerOptions;
import java.io.Serializable;
import org.apache.geaflow.cluster.rpc.RpcService;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceImpl
implements RpcService,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServiceImpl.class);
    private final int port;
    private final RpcServer server;

    public RpcServiceImpl(int port, RpcServerOptions options) {
        this.port = port;
        this.server = new RpcServer(port, options);
    }

    public void addEndpoint(Object rpcEndpoint) {
        this.server.registerService(rpcEndpoint);
    }

    @Override
    public int startService() {
        try {
            this.server.start();
            LOGGER.info("Brpc Server started: {}", (Object)this.port);
            return this.port;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new GeaflowRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void waitTermination() {
        RpcServer rpcServer = this.server;
        synchronized (rpcServer) {
            while (!this.server.isShutdown()) {
                try {
                    this.server.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("shutdown is interrupted");
                }
            }
        }
    }

    @Override
    public void stopService() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }
}

