/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.geaflow.cluster.resourcemanager.IResourceManager;
import org.apache.geaflow.cluster.resourcemanager.ReleaseResourceRequest;
import org.apache.geaflow.cluster.resourcemanager.ReleaseResponse;
import org.apache.geaflow.cluster.resourcemanager.RequireResourceRequest;
import org.apache.geaflow.cluster.resourcemanager.RequireResponse;
import org.apache.geaflow.cluster.resourcemanager.WorkerInfo;
import org.apache.geaflow.cluster.resourcemanager.allocator.IAllocator;
import org.apache.geaflow.cluster.rpc.IResourceManagerEndpoint;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.rpc.proto.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerEndpoint
implements IResourceManagerEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerEndpoint.class);
    private final IResourceManager resourceManager;

    public ResourceManagerEndpoint(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public Resource.RequireResourceResponse requireResource(Resource.RequireResourceRequest request) {
        try {
            RequireResponse requireResponse = this.resourceManager.requireResource(ResourceManagerEndpoint.convertRequireRequest(request));
            return ResourceManagerEndpoint.convertRequireResponse(requireResponse);
        }
        catch (Throwable t) {
            LOGGER.error("require resource failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("require resource failed: %s", t.getMessage()), t);
        }
    }

    @Override
    public Resource.ReleaseResourceResponse releaseResource(Resource.ReleaseResourceRequest request) {
        try {
            ReleaseResponse releaseResponse = this.resourceManager.releaseResource(ResourceManagerEndpoint.convertReleaseRequest(request));
            return ResourceManagerEndpoint.convertReleaseResponse(releaseResponse);
        }
        catch (Throwable t) {
            LOGGER.error("release resource failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("release resource failed: %s", t.getMessage()), t);
        }
    }

    private static RequireResourceRequest convertRequireRequest(Resource.RequireResourceRequest request) {
        IAllocator.AllocateStrategy strategy;
        switch (request.getAllocStrategy()) {
            case ROUND_ROBIN: {
                strategy = IAllocator.AllocateStrategy.ROUND_ROBIN;
                break;
            }
            case PROCESS_FAIR: {
                strategy = IAllocator.AllocateStrategy.PROCESS_FAIR;
                break;
            }
            default: {
                String msg = "unrecognized allocate strategy" + request.getAllocStrategy();
                throw new GeaflowRuntimeException(RuntimeErrors.INST.resourceError(msg));
            }
        }
        return RequireResourceRequest.build(request.getRequireId(), request.getWorkersNum(), strategy);
    }

    private static Resource.RequireResourceResponse convertRequireResponse(RequireResponse response) {
        Resource.RequireResourceResponse.Builder builder = Resource.RequireResourceResponse.newBuilder();
        boolean success = response.isSuccess();
        builder.setRequireId(response.getRequireId());
        builder.setSuccess(success);
        if (response.getMsg() != null) {
            builder.setMsg(response.getMsg());
        }
        if (!success) {
            return builder.build();
        }
        for (WorkerInfo workerInfo : response.getWorkers()) {
            Resource.Worker worker = Resource.Worker.newBuilder().setHost(workerInfo.getHost()).setProcessId(workerInfo.getProcessId()).setProcessIndex(workerInfo.getProcessIndex()).setRpcPort(workerInfo.getRpcPort()).setShufflePort(workerInfo.getShufflePort()).setWorkerId(workerInfo.getWorkerIndex()).setContainerId(workerInfo.getContainerName()).build();
            builder.addWorker(worker);
        }
        return builder.build();
    }

    private static ReleaseResourceRequest convertReleaseRequest(Resource.ReleaseResourceRequest request) {
        List<WorkerInfo> workerInfoList = request.getWorkerList().stream().map(w -> WorkerInfo.build(w.getHost(), w.getRpcPort(), w.getShufflePort(), w.getProcessId(), w.getProcessIndex(), w.getWorkerId(), w.getContainerId())).collect(Collectors.toList());
        return ReleaseResourceRequest.build(request.getReleaseId(), workerInfoList);
    }

    private static Resource.ReleaseResourceResponse convertReleaseResponse(ReleaseResponse response) {
        boolean success = response.isSuccess();
        Resource.ReleaseResourceResponse.Builder builder = Resource.ReleaseResourceResponse.newBuilder().setReleaseId(response.getReleaseId()).setSuccess(success);
        if (!success) {
            builder.setMsg(response.getMsg());
        }
        return builder.build();
    }
}

