/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.google.protobuf.ByteString;
import org.apache.geaflow.cluster.driver.Driver;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.cluster.rpc.IPipelineMasterEndpoint;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.rpc.proto.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineMasterEndpoint
implements IPipelineMasterEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineMasterEndpoint.class);
    private final Driver driver;

    public PipelineMasterEndpoint(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Container.Response process(Container.Request request) {
        try {
            IEvent event = (IEvent)RpcMessageEncoder.decode((ByteString)request.getPayload());
            this.driver.process(event);
            return Container.Response.newBuilder().build();
        }
        catch (Throwable t) {
            LOGGER.error("process event failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("process event failed: %s", t.getMessage()), t);
        }
    }
}

