/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.geaflow.cluster.rpc.IAsyncMetricEndpoint;
import org.apache.geaflow.cluster.rpc.IMetricEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcEndpointRefFactory;
import org.apache.geaflow.cluster.rpc.RpcUtil;
import org.apache.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.rpc.proto.Metrics;

public class MetricEndpointRef
extends AbstractRpcEndpointRef
implements IMetricEndpointRef {
    private IAsyncMetricEndpoint metricEndpoint;
    private final RpcEndpointRefFactory.EndpointRefID refID;

    public MetricEndpointRef(String host, int port, Configuration configuration) {
        super(host, port, configuration);
        this.refID = new RpcEndpointRefFactory.EndpointRefID(host, port, RpcEndpointRefFactory.EndpointType.METRIC);
    }

    @Override
    protected void getRpcEndpoint() {
        this.metricEndpoint = (IAsyncMetricEndpoint)BrpcProxy.getProxy((RpcClient)this.rpcClient, IAsyncMetricEndpoint.class);
    }

    @Override
    protected RpcClientOptions getClientOptions() {
        RpcClientOptions options = super.getClientOptions();
        options.setGlobalThreadPoolSharing(false);
        options.setMaxTotalConnections(2);
        options.setMinIdleConnections(1);
        options.setIoThreadNum(1);
        options.setWorkThreadNum(1);
        options.setLoadBalanceType(1);
        return options;
    }

    @Override
    public Future<Metrics.MetricQueryResponse> queryMetrics(Metrics.MetricQueryRequest request, RpcEndpointRef.RpcCallback<Metrics.MetricQueryResponse> callback) {
        CompletableFuture<Metrics.MetricQueryResponse> result = new CompletableFuture<Metrics.MetricQueryResponse>();
        RpcCallback<Metrics.MetricQueryResponse> rpcCallback = RpcUtil.buildRpcCallback(callback, result);
        try {
            this.metricEndpoint.queryMetrics(request, rpcCallback);
        }
        catch (Throwable e) {
            rpcCallback.fail(e);
            RpcEndpointRefFactory.getInstance().invalidateRef(this.refID);
        }
        return result;
    }
}

