/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import org.apache.geaflow.cluster.rpc.IMetricEndpoint;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.rpc.proto.Metrics;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.apache.geaflow.stats.model.MetricCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricEndpoint
implements IMetricEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricEndpoint.class);
    private final Configuration configuration;

    public MetricEndpoint(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Metrics.MetricQueryResponse queryMetrics(Metrics.MetricQueryRequest request) {
        try {
            MetricCache cache = StatsCollectorFactory.init((Configuration)this.configuration).getMetricCache();
            Metrics.MetricQueryResponse.Builder builder = Metrics.MetricQueryResponse.newBuilder();
            builder.setPayload(RpcMessageEncoder.encode((Object)cache));
            return builder.build();
        }
        catch (Throwable t) {
            LOGGER.error("process request failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("process request failed: %s", t.getMessage()), t);
        }
    }
}

