/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.geaflow.cluster.driver.DriverInfo;
import org.apache.geaflow.cluster.rpc.IAsyncMasterEndpoint;
import org.apache.geaflow.cluster.rpc.IMasterEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcUtil;
import org.apache.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.heartbeat.Heartbeat;
import org.apache.geaflow.rpc.proto.Master;

public class MasterEndpointRef
extends AbstractRpcEndpointRef
implements IMasterEndpointRef {
    private IAsyncMasterEndpoint masterEndpoint;

    public MasterEndpointRef(String host, int port, Configuration configuration) {
        super(host, port, configuration);
    }

    @Override
    protected void getRpcEndpoint() {
        this.masterEndpoint = (IAsyncMasterEndpoint)BrpcProxy.getProxy((RpcClient)this.rpcClient, IAsyncMasterEndpoint.class);
    }

    @Override
    public <T> Future<Master.RegisterResponse> registerContainer(T info, RpcEndpointRef.RpcCallback<Master.RegisterResponse> callback) {
        CompletableFuture<Master.RegisterResponse> result = new CompletableFuture<Master.RegisterResponse>();
        ByteString payload = RpcMessageEncoder.encode(info);
        Master.RegisterRequest register = Master.RegisterRequest.newBuilder().setPayload(payload).build();
        RpcCallback<Master.RegisterResponse> rpcCallback = RpcUtil.buildRpcCallback(callback, result);
        if (info instanceof DriverInfo) {
            this.masterEndpoint.registerDriver(register, rpcCallback);
        } else {
            this.masterEndpoint.registerContainer(register, rpcCallback);
        }
        return result;
    }

    @Override
    public Future<Master.HeartbeatResponse> sendHeartBeat(Heartbeat heartbeat, RpcEndpointRef.RpcCallback<Master.HeartbeatResponse> callback) {
        CompletableFuture<Master.HeartbeatResponse> result = new CompletableFuture<Master.HeartbeatResponse>();
        Master.HeartbeatRequest heartbeatRequest = Master.HeartbeatRequest.newBuilder().setId(heartbeat.getContainerId()).setTimestamp(heartbeat.getTimestamp()).setName(RpcMessageEncoder.encode((Object)heartbeat.getContainerName())).setPayload(RpcMessageEncoder.encode((Object)heartbeat.getProcessMetrics())).build();
        RpcCallback<Master.HeartbeatResponse> rpcCallback = RpcUtil.buildRpcCallback(callback, result);
        this.masterEndpoint.receiveHeartbeat(heartbeatRequest, rpcCallback);
        return result;
    }

    @Override
    public Empty sendException(Integer containerId, String containerName, String message) {
        Master.HeartbeatRequest heartbeatRequest = Master.HeartbeatRequest.newBuilder().setId(containerId.intValue()).setName(RpcMessageEncoder.encode((Object)containerName)).setPayload(RpcMessageEncoder.encode((Object)message)).build();
        return this.masterEndpoint.receiveException(heartbeatRequest);
    }

    @Override
    public void closeEndpoint() {
        this.masterEndpoint.close(Empty.newBuilder().build());
        super.closeEndpoint();
    }
}

