/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import org.apache.geaflow.cluster.clustermanager.AbstractClusterManager;
import org.apache.geaflow.cluster.clustermanager.IClusterManager;
import org.apache.geaflow.cluster.container.ContainerInfo;
import org.apache.geaflow.cluster.driver.DriverInfo;
import org.apache.geaflow.cluster.heartbeat.HeartbeatManager;
import org.apache.geaflow.cluster.master.IMaster;
import org.apache.geaflow.cluster.rpc.IMasterEndpoint;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.common.heartbeat.Heartbeat;
import org.apache.geaflow.common.metric.ProcessMetrics;
import org.apache.geaflow.rpc.proto.Master;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterEndpoint
implements IMasterEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(MasterEndpoint.class);
    private final IMaster master;
    private final IClusterManager clusterManager;

    public MasterEndpoint(IMaster master, IClusterManager clusterManager) {
        this.master = master;
        this.clusterManager = clusterManager;
    }

    @Override
    public Master.RegisterResponse registerContainer(Master.RegisterRequest request) {
        try {
            ContainerInfo containerInfo = (ContainerInfo)RpcMessageEncoder.decode((ByteString)request.getPayload());
            return ((AbstractClusterManager)this.clusterManager).registerContainer(containerInfo);
        }
        catch (Throwable t) {
            LOGGER.error("register container failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("register container failed: %s", t.getMessage()), t);
        }
    }

    @Override
    public Master.RegisterResponse registerDriver(Master.RegisterRequest request) {
        try {
            DriverInfo driverInfo = (DriverInfo)RpcMessageEncoder.decode((ByteString)request.getPayload());
            return ((AbstractClusterManager)this.clusterManager).registerDriver(driverInfo);
        }
        catch (Throwable t) {
            LOGGER.error("register driver failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("register driver failed: %s", t.getMessage()), t);
        }
    }

    @Override
    public Master.HeartbeatResponse receiveHeartbeat(Master.HeartbeatRequest request) {
        try {
            Heartbeat heartbeat = new Heartbeat(request.getId());
            heartbeat.setTimestamp(request.getTimestamp());
            heartbeat.setContainerName((String)RpcMessageEncoder.decode((ByteString)request.getName()));
            heartbeat.setProcessMetrics((ProcessMetrics)RpcMessageEncoder.decode((ByteString)request.getPayload()));
            HeartbeatManager heartbeatManager = ((AbstractClusterManager)this.clusterManager).getClusterContext().getHeartbeatManager();
            return heartbeatManager.receivedHeartbeat(heartbeat);
        }
        catch (Throwable t) {
            LOGGER.error("process {} heartbeat failed: {}", new Object[]{request.getId(), t.getMessage(), t});
            throw new GeaflowRuntimeException(String.format("process %s heartbeat failed: %s", request.getId(), t.getMessage()), t);
        }
    }

    @Override
    public Empty receiveException(Master.HeartbeatRequest request) {
        try {
            int containerId = request.getId();
            String containerName = (String)RpcMessageEncoder.decode((ByteString)request.getName());
            String errMessage = (String)RpcMessageEncoder.decode((ByteString)request.getPayload());
            LOGGER.info("received exception from {}: {}", (Object)containerName, (Object)errMessage);
            this.clusterManager.doFailover(containerId, new RuntimeException(errMessage));
            return Empty.newBuilder().build();
        }
        catch (Throwable t) {
            LOGGER.error("process {} heartbeat failed: {}", new Object[]{request.getId(), t.getMessage(), t});
            throw new GeaflowRuntimeException(String.format("process %s heartbeat failed: %s", request.getId(), t.getMessage()), t);
        }
    }

    @Override
    public Empty close(Empty request) {
        try {
            this.master.close();
            return Empty.newBuilder().build();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("close failed: %s", t.getMessage()), t);
        }
    }
}

