/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.concurrent.CompletableFuture;
import org.apache.geaflow.cluster.client.PipelineResult;
import org.apache.geaflow.cluster.rpc.IAsyncDriverEndpoint;
import org.apache.geaflow.cluster.rpc.IDriverEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcUtil;
import org.apache.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.pipeline.IPipelineResult;
import org.apache.geaflow.pipeline.Pipeline;
import org.apache.geaflow.rpc.proto.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverEndpointRef
extends AbstractRpcEndpointRef
implements IDriverEndpointRef {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverEndpointRef.class);
    private IAsyncDriverEndpoint driverEndpoint;

    public DriverEndpointRef(String host, int port, Configuration configuration) {
        super(host, port, configuration);
    }

    @Override
    protected void getRpcEndpoint() {
        this.driverEndpoint = (IAsyncDriverEndpoint)BrpcProxy.getProxy((RpcClient)this.rpcClient, IAsyncDriverEndpoint.class);
    }

    @Override
    public IPipelineResult executePipeline(Pipeline pipeline) {
        LOGGER.info("send pipeline to driver, driver host:{}, port:{}. {}", new Object[]{this.host, this.port, pipeline});
        ByteString payload = RpcMessageEncoder.encode((Object)pipeline);
        Driver.PipelineReq req = Driver.PipelineReq.newBuilder().setPayload(payload).build();
        CompletableFuture<Driver.PipelineRes> result = new CompletableFuture<Driver.PipelineRes>();
        RpcCallback rpcCallback = RpcUtil.buildRpcCallback(null, result);
        this.driverEndpoint.executePipeline(req, rpcCallback);
        return new PipelineResult(result);
    }

    @Override
    public void closeEndpoint() {
        this.driverEndpoint.close(Empty.newBuilder().build());
        super.closeEndpoint();
    }
}

