/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import org.apache.geaflow.cluster.driver.IDriver;
import org.apache.geaflow.cluster.rpc.IDriverEndpoint;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.pipeline.Pipeline;
import org.apache.geaflow.rpc.proto.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverEndpoint
implements IDriverEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverEndpoint.class);
    private final IDriver driver;

    public DriverEndpoint(IDriver driver) {
        this.driver = driver;
    }

    @Override
    public Driver.PipelineRes executePipeline(Driver.PipelineReq request) {
        try {
            Pipeline pipeline = (Pipeline)RpcMessageEncoder.decode((ByteString)request.getPayload());
            Object result = this.driver.executePipeline(pipeline);
            return Driver.PipelineRes.newBuilder().setPayload(RpcMessageEncoder.encode(result)).build();
        }
        catch (Throwable e) {
            LOGGER.error("execute pipeline failed: {}", (Object)e.getMessage(), (Object)e);
            throw new GeaflowRuntimeException(String.format("execute pipeline failed: %s", e.getMessage()), e);
        }
    }

    @Override
    public Empty close(Empty request) {
        try {
            this.driver.close();
            return Empty.newBuilder().build();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("close failed: %s", t.getMessage(), t));
        }
    }
}

