/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.cluster.rpc.IAsyncContainerEndpoint;
import org.apache.geaflow.cluster.rpc.IContainerEndpointRef;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.rpc.proto.Container;

public class ContainerEndpointRef
extends AbstractRpcEndpointRef
implements IContainerEndpointRef {
    protected IAsyncContainerEndpoint containerEndpoint;

    public ContainerEndpointRef(String host, int port, Configuration configuration) {
        super(host, port, configuration);
    }

    @Override
    protected void getRpcEndpoint() {
        this.containerEndpoint = (IAsyncContainerEndpoint)BrpcProxy.getProxy((RpcClient)this.rpcClient, IAsyncContainerEndpoint.class);
    }

    @Override
    public Future<IEvent> process(IEvent request, final RpcEndpointRef.RpcCallback<Container.Response> callback) {
        final CompletableFuture<IEvent> result = new CompletableFuture<IEvent>();
        Container.Request req = this.buildRequest(request);
        this.containerEndpoint.process(req, new RpcCallback<Container.Response>(){

            public void success(Container.Response response) {
                ByteString payload;
                if (callback != null) {
                    callback.onSuccess(response);
                }
                IEvent event = (payload = response.getPayload()) == ByteString.EMPTY ? null : (IEvent)RpcMessageEncoder.decode((ByteString)payload);
                result.complete(event);
            }

            public void fail(Throwable throwable) {
                callback.onFailure(throwable);
                result.completeExceptionally(throwable);
            }
        });
        return result;
    }

    @Override
    public void closeEndpoint() {
        this.containerEndpoint.close(Empty.newBuilder().build());
        super.closeEndpoint();
    }

    protected Container.Request buildRequest(IEvent request) {
        ByteString payload = RpcMessageEncoder.encode((Object)request);
        return Container.Request.newBuilder().setPayload(payload).build();
    }
}

