/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import org.apache.geaflow.cluster.container.Container;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.cluster.protocol.OpenContainerEvent;
import org.apache.geaflow.cluster.rpc.IContainerEndpoint;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.rpc.proto.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEndpoint
implements IContainerEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerEndpoint.class);
    private final Container container;

    public ContainerEndpoint(Container workerContainer) {
        this.container = workerContainer;
    }

    @Override
    public Container.Response process(Container.Request request) {
        Container.Response.Builder builder = Container.Response.newBuilder();
        try {
            IEvent event = (IEvent)RpcMessageEncoder.decode((ByteString)request.getPayload());
            IEvent res = event instanceof OpenContainerEvent ? this.container.open((OpenContainerEvent)event) : this.container.process(event);
            if (res != null) {
                ByteString payload = RpcMessageEncoder.encode((Object)res);
                builder.setPayload(payload);
            }
            return builder.build();
        }
        catch (Throwable t) {
            LOGGER.error("process request failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException("process request failed", t);
        }
    }

    @Override
    public Empty close(Empty request) {
        try {
            this.container.close();
            return Empty.newBuilder().build();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            throw new GeaflowRuntimeException(String.format("close failed: %s", t.getMessage()), t);
        }
    }
}

