/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc.impl;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.client.channel.Endpoint;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.rpc.ConfigurableClientOption;

public abstract class AbstractRpcEndpointRef
implements RpcEndpointRef {
    protected RpcClient rpcClient;
    protected final String host;
    protected final int port;
    protected final Configuration configuration;

    public AbstractRpcEndpointRef(String host, int port, Configuration configuration) {
        this.host = host;
        this.port = port;
        this.configuration = configuration;
        this.rpcClient = new RpcClient(new Endpoint(host, port), this.getClientOptions());
        this.getRpcEndpoint();
    }

    protected abstract void getRpcEndpoint();

    protected synchronized RpcClientOptions getClientOptions() {
        return ConfigurableClientOption.build((Configuration)this.configuration);
    }

    @Override
    public void closeEndpoint() {
        this.close();
    }

    @Override
    public void close() {
        if (!this.rpcClient.isShutdown()) {
            this.rpcClient.stop();
        }
    }
}

