/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc;

import com.baidu.brpc.client.RpcCallback;
import io.grpc.Context;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;

public class RpcUtil
implements Serializable {
    public static void asyncExecute(Runnable runnable) {
        Context.current().fork().run(runnable);
    }

    public static <T> RpcCallback<T> buildRpcCallback(final RpcEndpointRef.RpcCallback<T> listener, final CompletableFuture<T> result) {
        return new RpcCallback<T>(){

            public void success(T response) {
                if (listener != null) {
                    listener.onSuccess(response);
                }
                result.complete(response);
            }

            public void fail(Throwable t) {
                if (listener != null) {
                    listener.onFailure(t);
                }
                result.completeExceptionally(t);
            }
        };
    }
}

