/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.ContainerEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.DriverEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.MasterEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.MetricEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.PipelineMasterEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.ResourceManagerEndpointRef;
import org.apache.geaflow.cluster.rpc.impl.SupervisorEndpointRef;
import org.apache.geaflow.common.config.Configuration;

public class RpcEndpointRefFactory
implements Serializable {
    private final Map<EndpointRefID, RpcEndpointRef> endpointRefMap = new ConcurrentHashMap<EndpointRefID, RpcEndpointRef>();
    private final Configuration configuration;
    private static RpcEndpointRefFactory INSTANCE;

    private RpcEndpointRefFactory(Configuration config) {
        this.configuration = config;
    }

    public static synchronized RpcEndpointRefFactory getInstance(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new RpcEndpointRefFactory(config);
        }
        return INSTANCE;
    }

    public static synchronized RpcEndpointRefFactory getInstance() {
        return INSTANCE;
    }

    public MasterEndpointRef connectMaster(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.MASTER);
        try {
            return (MasterEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new MasterEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect master error, host " + host + " port " + port, t);
        }
    }

    public ResourceManagerEndpointRef connectResourceManager(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.RESOURCE_MANAGER);
        try {
            return (ResourceManagerEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new ResourceManagerEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect rm error, host " + host + " port " + port, t);
        }
    }

    public DriverEndpointRef connectDriver(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.DRIVER);
        try {
            return (DriverEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new DriverEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect driver error, host " + host + " port " + port, t);
        }
    }

    public PipelineMasterEndpointRef connectPipelineManager(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.PIPELINE_MANAGER);
        try {
            return (PipelineMasterEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new PipelineMasterEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect pipeline master error, host " + host + " port " + port, t);
        }
    }

    public ContainerEndpointRef connectContainer(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.CONTAINER);
        try {
            return (ContainerEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new ContainerEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect container error, host " + host + " port " + port, t);
        }
    }

    public SupervisorEndpointRef connectSupervisor(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.SUPERVISOR);
        try {
            return (SupervisorEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new SupervisorEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect container error, host " + host + " port " + port, t);
        }
    }

    public MetricEndpointRef connectMetricServer(String host, int port) {
        EndpointRefID refID = new EndpointRefID(host, port, EndpointType.METRIC);
        try {
            return (MetricEndpointRef)this.endpointRefMap.computeIfAbsent(refID, key -> new MetricEndpointRef(host, port, this.configuration));
        }
        catch (Throwable t) {
            this.invalidateRef(refID);
            throw new RuntimeException("connect container error, host " + host + " port " + port, t);
        }
    }

    public void invalidateEndpointCache(String host, int port, EndpointType endpointType) {
        this.invalidateRef(new EndpointRefID(host, port, endpointType));
    }

    public void invalidateRef(EndpointRefID refId) {
        this.endpointRefMap.remove(refId);
    }

    public static class EndpointRefID {
        private String host;
        private int port;
        private EndpointType endpointType;

        public EndpointRefID(String host, int port, EndpointType endpointType) {
            this.host = host;
            this.port = port;
            this.endpointType = endpointType;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public EndpointType getEndpointType() {
            return this.endpointType;
        }

        public void setEndpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointRefID that = (EndpointRefID)o;
            return this.port == that.port && this.host.equals(that.host) && this.endpointType == that.endpointType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.host, this.port, this.endpointType});
        }

        public String toString() {
            return "EndpointRefID{host='" + this.host + '\'' + ", port=" + this.port + ", endpointType=" + (Object)((Object)this.endpointType) + '}';
        }
    }

    public static enum EndpointType {
        MASTER,
        RESOURCE_MANAGER,
        DRIVER,
        PIPELINE_MANAGER,
        CONTAINER,
        SUPERVISOR,
        METRIC;

    }
}

