/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.rpc;

import java.io.Serializable;
import java.util.Objects;

public class ConnectAddress
implements Serializable {
    public static final String PORT_SEPARATOR = ":";
    private String host;
    private int port;

    public ConnectAddress() {
    }

    public ConnectAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectAddress that = (ConnectAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + PORT_SEPARATOR + this.port;
    }

    public static ConnectAddress build(String address) {
        ConnectAddress rpcAddress = new ConnectAddress();
        String[] hostAndPort = address.split(PORT_SEPARATOR);
        rpcAddress.setHost(hostAndPort[0]);
        rpcAddress.setPort(Integer.parseInt(hostAndPort[1]));
        return rpcAddress;
    }
}

