/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.response;

import java.util.List;
import org.apache.geaflow.cluster.response.IResult;
import org.apache.geaflow.shuffle.desc.OutputType;
import org.apache.geaflow.shuffle.message.ISliceMeta;

public class ShardResult
implements IResult<ISliceMeta> {
    private int id;
    private OutputType outputType;
    private List<ISliceMeta> slices;
    private long recordNum;
    private long recordBytes;

    public ShardResult(int id, OutputType outputType, List<ISliceMeta> slices) {
        this.id = id;
        this.outputType = outputType;
        this.slices = slices;
        if (slices != null) {
            for (ISliceMeta sliceMeta : slices) {
                this.recordNum += sliceMeta.getRecordNum();
                this.recordBytes += sliceMeta.getEncodedSize();
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<ISliceMeta> getResponse() {
        return this.slices;
    }

    public long getRecordNum() {
        return this.recordNum;
    }

    public long getRecordBytes() {
        return this.recordBytes;
    }

    @Override
    public OutputType getType() {
        return this.outputType;
    }
}

