/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.resourcemanager.allocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.geaflow.cluster.resourcemanager.WorkerInfo;
import org.apache.geaflow.cluster.resourcemanager.allocator.AbstractAllocator;
import org.apache.geaflow.cluster.resourcemanager.allocator.IAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFairAllocator
extends AbstractAllocator<String, WorkerInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessFairAllocator.class);
    private static final String SEPARATOR = "-";

    @Override
    public List<WorkerInfo> doAllocate(int num) {
        int processNum = this.group2workers.size();
        if (num % processNum != 0) {
            LOGGER.warn("require num must be a multiple of process num, available {} require {}", (Object)this.group2workers.size(), (Object)num);
            return Collections.emptyList();
        }
        ArrayList<WorkerInfo> allocated = new ArrayList<WorkerInfo>();
        int nPerProc = num / processNum;
        for (Map.Entry entry : this.group2workers.entrySet()) {
            String key = ((Comparable)entry.getKey()).toString();
            LinkedList list = (LinkedList)entry.getValue();
            if (list.size() < nPerProc) {
                LOGGER.warn("not enough worker for jvm {}, available {} require {}", new Object[]{key, list.size(), nPerProc});
                return Collections.emptyList();
            }
            IntStream.range(0, nPerProc).forEach(i -> allocated.add((WorkerInfo)list.pollFirst()));
        }
        this.assembleProcessIndexId(processNum, allocated);
        return allocated;
    }

    @Override
    public IAllocator.WorkerGroupByFunction<String, WorkerInfo> getWorkerGroupByFunction() {
        return PROC_GROUP_SELECTOR;
    }

    @Override
    public IAllocator.AllocateStrategy getStrategy() {
        return IAllocator.AllocateStrategy.PROCESS_FAIR;
    }

    public void assembleProcessIndexId(int processNum, List<WorkerInfo> workers) {
        Collections.sort(workers, new Comparator<WorkerInfo>(){

            @Override
            public int compare(WorkerInfo o1, WorkerInfo o2) {
                return (o1.getHost() + ProcessFairAllocator.SEPARATOR + o1.getProcessId()).compareTo(o2.getHost() + ProcessFairAllocator.SEPARATOR + o2.getProcessId());
            }
        });
        int step = workers.size() / processNum;
        int globalProcessIndex = 0;
        for (int i = 0; i < workers.size(); i += step) {
            for (int j = 0; j < step; ++j) {
                workers.get(i + j).setProcessIndex(globalProcessIndex);
            }
            ++globalProcessIndex;
        }
    }
}

