/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.protocol;

import java.util.List;
import org.apache.geaflow.cluster.protocol.AbstractMessage;

public class OutputMessage<T>
extends AbstractMessage<List<T>> {
    private final int targetChannel;
    private final List<T> data;
    private final boolean isBarrier;

    public OutputMessage(long windowId, int targetChannel, List<T> data) {
        super(windowId);
        this.targetChannel = targetChannel;
        this.data = data;
        this.isBarrier = data == null;
    }

    @Override
    public List<T> getMessage() {
        return this.data;
    }

    public int getTargetChannel() {
        return this.targetChannel;
    }

    public boolean isBarrier() {
        return this.isBarrier;
    }

    public static <T> OutputMessage<T> data(long windowId, int targetChannel, List<T> data) {
        return new OutputMessage<T>(windowId, targetChannel, data);
    }

    public static <T> OutputMessage<T> barrier(long windowId) {
        return new OutputMessage<T>(windowId, -1, null);
    }
}

