/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.heartbeat;

import java.io.Serializable;
import org.apache.geaflow.cluster.common.ComponentInfo;
import org.apache.geaflow.cluster.heartbeat.HeartbeatSender;
import org.apache.geaflow.cluster.rpc.RpcClient;
import org.apache.geaflow.cluster.rpc.RpcEndpointRef;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.heartbeat.Heartbeat;
import org.apache.geaflow.rpc.proto.Master;
import org.apache.geaflow.stats.collector.ProcessStatsCollector;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatClient<T extends ComponentInfo>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatClient.class);
    private final int containerId;
    private final String containerName;
    private final Configuration config;
    private HeartbeatSender heartbeatSender;
    private final ProcessStatsCollector statsCollector;
    private T info;
    private String masterId;

    public HeartbeatClient(int containerId, String containerName, Configuration config) {
        this.containerId = containerId;
        this.containerName = containerName;
        this.config = config;
        this.statsCollector = StatsCollectorFactory.getInstance().getProcessStatsCollector();
    }

    public void init(String masterId, T info) {
        this.masterId = masterId;
        this.info = info;
        this.registerToMaster();
        this.startHeartBeat(masterId);
    }

    public void registerToMaster() {
        LOGGER.info("register: {}", this.info);
        RpcClient.init(this.config);
        this.doRegister(this.masterId, this.info);
    }

    private void doRegister(String masterId, T info) {
        RpcClient.getInstance().registerContainer(masterId, info, new RpcEndpointRef.RpcCallback<Master.RegisterResponse>(){

            @Override
            public void onSuccess(Master.RegisterResponse event) {
                LOGGER.info("{} registered success:{}", (Object)HeartbeatClient.this.containerName, (Object)event.getSuccess());
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("register info failed", t);
            }
        });
    }

    public void startHeartBeat(String masterId) {
        LOGGER.info("start {} heartbeat", (Object)this.containerName);
        this.heartbeatSender = new HeartbeatSender(masterId, () -> {
            Heartbeat heartbeat = null;
            if (this.containerName != null) {
                heartbeat = new Heartbeat(this.containerId);
                heartbeat.setContainerName(this.containerName);
                heartbeat.setProcessMetrics(this.statsCollector.collect());
            }
            return heartbeat;
        }, this.config, this);
        this.heartbeatSender.start();
    }

    public void close() {
        if (this.heartbeatSender != null) {
            this.heartbeatSender.close();
        }
    }
}

