/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.fetcher;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.geaflow.cluster.fetcher.FetcherRunner;
import org.apache.geaflow.cluster.fetcher.IFetchRequest;
import org.apache.geaflow.cluster.task.service.AbstractTaskService;
import org.apache.geaflow.common.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherService
extends AbstractTaskService<IFetchRequest, FetcherRunner>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetcherService.class);
    private static final String FETCHER_FORMAT = "geaflow-fetcher-%d";
    private int slots;

    public FetcherService(int slots, Configuration configuration) {
        super(configuration, FETCHER_FORMAT);
        this.slots = slots;
    }

    protected FetcherRunner[] buildTaskRunner() {
        Preconditions.checkArgument((this.slots > 0 ? 1 : 0) != 0, (Object)"fetcher pool should be larger than 0");
        FetcherRunner[] fetcherRunners = new FetcherRunner[this.slots];
        for (int i = 0; i < this.slots; ++i) {
            FetcherRunner runner;
            fetcherRunners[i] = runner = new FetcherRunner(this.configuration);
        }
        return fetcherRunners;
    }
}

