/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.fetcher;

import org.apache.geaflow.cluster.fetcher.CloseFetchRequest;
import org.apache.geaflow.cluster.fetcher.FetchRequest;
import org.apache.geaflow.cluster.fetcher.IFetchRequest;
import org.apache.geaflow.cluster.fetcher.InitFetchRequest;
import org.apache.geaflow.cluster.fetcher.PipelineInputFetcher;
import org.apache.geaflow.cluster.task.runner.AbstractTaskRunner;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherRunner
extends AbstractTaskRunner<IFetchRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetcherRunner.class);
    private final PipelineInputFetcher fetcher;

    public FetcherRunner(Configuration configuration) {
        this.fetcher = new PipelineInputFetcher(configuration);
    }

    @Override
    protected void process(IFetchRequest task) {
        IFetchRequest.RequestType requestType = task.getRequestType();
        switch (requestType) {
            case INIT: {
                this.fetcher.init((InitFetchRequest)task);
                break;
            }
            case FETCH: {
                this.fetcher.fetch((FetchRequest)task);
                break;
            }
            case CLOSE: {
                this.fetcher.close((CloseFetchRequest)task);
                break;
            }
            default: {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.requestTypeNotSupportError(requestType.name()));
            }
        }
    }

    @Override
    public void interrupt() {
        LOGGER.info("cancel fetcher runner");
        this.fetcher.cancel();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.fetcher.close();
    }
}

