/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.failover;

import java.util.ServiceLoader;
import org.apache.geaflow.cluster.failover.IFailoverStrategy;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.env.IEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailoverStrategyFactory.class);

    public static IFailoverStrategy loadFailoverStrategy(IEnvironment.EnvType envType, String foStrategyType) {
        ServiceLoader<IFailoverStrategy> contextLoader = ServiceLoader.load(IFailoverStrategy.class);
        for (IFailoverStrategy strategy : contextLoader) {
            if (strategy.getEnv() != envType || !strategy.getType().name().equalsIgnoreCase(foStrategyType)) continue;
            return strategy;
        }
        LOGGER.error("NOT found IFoStrategy implementation with type:{}", (Object)foStrategyType);
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IFailoverStrategy.class.getSimpleName()));
    }
}

