/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.executor;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.geaflow.cluster.executor.IPipelineExecutor;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineExecutorFactory.class);

    public static IPipelineExecutor createPipelineExecutor() {
        ServiceLoader<IPipelineExecutor> executorLoader = ServiceLoader.load(IPipelineExecutor.class);
        Iterator<IPipelineExecutor> executorIterable = executorLoader.iterator();
        if (executorIterable.hasNext()) {
            return executorIterable.next();
        }
        LOGGER.error("NOT found IPipelineExecutor implementation");
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IPipelineExecutor.class.getSimpleName()));
    }
}

