/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.exception;

import org.apache.geaflow.cluster.rpc.RpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionClient.class);
    private static ExceptionClient INSTANCE;
    private final String masterId;
    private final int containerId;
    private final String containerName;

    public ExceptionClient(int containerId, String containerName, String masterId) {
        this.containerId = containerId;
        this.containerName = containerName;
        this.masterId = masterId;
    }

    public static synchronized ExceptionClient init(int containerId, String name, String masterId) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionClient(containerId, name, masterId);
        }
        return INSTANCE;
    }

    public static synchronized ExceptionClient getInstance() {
        return INSTANCE;
    }

    public void sendException(Throwable throwable) {
        try {
            LOGGER.info("Send exception {} to master.", (Object)throwable.getMessage());
            RpcClient.getInstance().sendException(this.masterId, this.containerId, this.containerName, throwable);
        }
        catch (Throwable e) {
            LOGGER.error("Send exception {} to master failed.", (Object)throwable.getMessage(), (Object)e);
        }
    }
}

