/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.exception;

import org.apache.geaflow.cluster.exception.ComponentExceptionSupervisor;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.apache.geaflow.stats.model.ExceptionLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentUncaughtExceptionHandler.class);
    public static final ComponentUncaughtExceptionHandler INSTANCE = new ComponentUncaughtExceptionHandler();

    @Override
    public void uncaughtException(Thread thread, Throwable cause) {
        LOGGER.error("FATAL exception in thread: {}", (Object)thread.getName(), (Object)cause);
        StatsCollectorFactory collectorFactory = StatsCollectorFactory.getInstance();
        if (collectorFactory != null) {
            collectorFactory.getExceptionCollector().reportException(ExceptionLevel.FATAL, cause);
        }
        ComponentExceptionSupervisor.getInstance().add(ComponentExceptionSupervisor.ExceptionElement.of(thread, cause));
    }
}

