/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.driver;

import java.util.HashMap;
import java.util.Map;
import org.apache.geaflow.cluster.common.IDispatcher;
import org.apache.geaflow.cluster.common.IEventListener;
import org.apache.geaflow.cluster.protocol.ICycleResponseEvent;
import org.apache.geaflow.cluster.protocol.IEvent;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;

public class DriverEventDispatcher
implements IDispatcher {
    private Map<Long, IEventListener> eventListenerMap = new HashMap<Long, IEventListener>();

    @Override
    public void dispatch(IEvent event) {
        ICycleResponseEvent doneEvent = (ICycleResponseEvent)event;
        IEventListener eventListener = this.eventListenerMap.get(doneEvent.getSchedulerId());
        if (eventListener == null) {
            throw new GeaflowRuntimeException(String.format("event %s do not find handle listener %s", event, doneEvent.getSchedulerId()));
        }
        eventListener.handleEvent(event);
    }

    public void registerListener(long schedulerId, IEventListener eventListener) {
        this.eventListenerMap.put(schedulerId, eventListener);
    }

    public void removeListener(long schedulerId) {
        this.eventListenerMap.remove(schedulerId);
    }
}

