/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.driver;

import java.util.ArrayList;
import java.util.List;
import org.apache.geaflow.cluster.common.ExecutionIdGenerator;
import org.apache.geaflow.cluster.common.IReliableContext;
import org.apache.geaflow.cluster.common.ReliableContainerContext;
import org.apache.geaflow.cluster.constants.ClusterConstants;
import org.apache.geaflow.cluster.driver.Driver;
import org.apache.geaflow.cluster.failover.FailoverStrategyType;
import org.apache.geaflow.cluster.system.ClusterMetaStore;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.pipeline.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverContext
extends ReliableContainerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(Driver.class);
    private Pipeline pipeline;
    private List<Long> pipelineTaskIds;
    private List<Integer> finishedPipelineTasks;
    private int index;

    public List<Long> getPipelineTaskIds() {
        return this.pipelineTaskIds;
    }

    public DriverContext(int id, int index, Configuration config) {
        super(id, ClusterConstants.getDriverName(id), config);
        this.index = index;
        this.finishedPipelineTasks = new ArrayList<Integer>();
        this.pipelineTaskIds = new ArrayList<Long>();
    }

    public DriverContext(int id, int index, Configuration config, boolean isRecover) {
        this(id, index, config);
        this.isRecover = isRecover;
    }

    @Override
    public void load() {
        Pipeline pipeline = ClusterMetaStore.getInstance(this.id, this.name, this.config).getPipeline();
        if (pipeline != null) {
            List<Integer> finishedPipelineTasks = ClusterMetaStore.getInstance().getPipelineTasks();
            if (finishedPipelineTasks == null) {
                finishedPipelineTasks = new ArrayList<Integer>();
            }
            List<Long> pipelineTaskIds = ClusterMetaStore.getInstance().getPipelineTaskIds();
            if (pipeline.getPipelineTaskList() != null && pipelineTaskIds == null) {
                throw new GeaflowRuntimeException(String.format("driver %s recover context %s error: pipeline task ids is null", this.id, this));
            }
            this.pipeline = pipeline;
            this.finishedPipelineTasks = finishedPipelineTasks;
            this.pipelineTaskIds = pipelineTaskIds;
            LOGGER.info("driver {} recover context {} pipeline {} finishedPipelineTasks {} pipelineTaskIds {}", new Object[]{this.id, this, pipeline, finishedPipelineTasks, pipelineTaskIds});
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void addPipeline(Pipeline pipeline) {
        this.genPipelineTaskIds(pipeline);
        this.validatePipeline(pipeline);
        if (!pipeline.equals(this.pipeline)) {
            this.pipeline = pipeline;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public List<Integer> getFinishedPipelineTasks() {
        return this.finishedPipelineTasks;
    }

    public void addFinishedPipelineTask(int pipelineTaskIndex) {
        if (!this.finishedPipelineTasks.contains(pipelineTaskIndex)) {
            this.finishedPipelineTasks.add(pipelineTaskIndex);
        }
    }

    private void validatePipeline(Pipeline pipeline) {
        if (!pipeline.getPipelineTaskList().isEmpty() && this.config.getString(ExecutionConfigKeys.FO_STRATEGY).equalsIgnoreCase(FailoverStrategyType.component_fo.name())) {
            throw new GeaflowRuntimeException("not support component_fo for executing pipeline tasks");
        }
    }

    private void genPipelineTaskIds(Pipeline pipeline) {
        if (this.pipelineTaskIds.isEmpty()) {
            int size = pipeline.getPipelineTaskList().size();
            for (int i = 0; i < size; ++i) {
                this.pipelineTaskIds.add(ExecutionIdGenerator.getInstance().generateId());
            }
        }
    }

    public static class PipelineTaskCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            DriverContext driverContext = (DriverContext)context;
            if (driverContext.getFinishedPipelineTasks() != null && !driverContext.getFinishedPipelineTasks().isEmpty()) {
                ClusterMetaStore.getInstance().savePipelineTasks(driverContext.getFinishedPipelineTasks()).flush();
                LOGGER.info("driver {} checkpoint pipeline finished tasks {}", (Object)driverContext.getId(), driverContext.getFinishedPipelineTasks());
            }
        }
    }

    public static class PipelineCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            DriverContext driverContext = (DriverContext)context;
            if (driverContext.getPipeline() != null) {
                ClusterMetaStore.getInstance().savePipeline(driverContext.getPipeline()).flush();
                ClusterMetaStore.getInstance().savePipelineTaskIds(driverContext.getPipelineTaskIds()).flush();
                LOGGER.info("driver {} checkpoint context {} pipeline {}, PipelineTaskIds {}", new Object[]{driverContext.getId(), driverContext, driverContext.getPipeline(), driverContext.getPipelineTaskIds()});
            }
        }
    }
}

