/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.geaflow.cluster.client.utils.PipelineUtil;
import org.apache.geaflow.cluster.config.ClusterJvmOptions;
import org.apache.geaflow.cluster.failover.FailoverStrategyType;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;

public class ClusterConfig
implements Serializable {
    private static final double DEFAULT_HEAP_FRACTION = 0.8;
    private int containerNum;
    private int containerMemoryMB;
    private int containerDiskGB;
    private double containerVcores;
    private int containerWorkerNum;
    private ClusterJvmOptions containerJvmOptions;
    private int masterMemoryMB;
    private int masterDiskGB;
    private double masterVcores;
    private ClusterJvmOptions masterJvmOptions;
    private int driverNum;
    private int driverMemoryMB;
    private int driverDiskGB;
    private double driverVcores;
    private ClusterJvmOptions driverJvmOptions;
    private int clientMemoryMB;
    private int clientDiskGB;
    private double clientVcores;
    private ClusterJvmOptions clientJvmOptions;
    private boolean isFoEnable;
    private int maxRestarts;
    private Configuration config;
    private ClusterJvmOptions supervisorJvmOptions;

    public static ClusterConfig build(Configuration config) {
        ClusterJvmOptions containerJvmOptions;
        ClusterConfig clusterConfig = new ClusterConfig();
        clusterConfig.setMasterMemoryMB(config.getInteger(ExecutionConfigKeys.MASTER_MEMORY_MB));
        clusterConfig.setMasterDiskGB(config.getInteger(ExecutionConfigKeys.MASTER_DISK_GB));
        ClusterJvmOptions masterJvmOptions = ClusterJvmOptions.build(config.getString(ExecutionConfigKeys.MASTER_JVM_OPTIONS));
        clusterConfig.setMasterJvmOptions(masterJvmOptions);
        clusterConfig.setMasterVcores(config.getDouble(ExecutionConfigKeys.MASTER_VCORES));
        ClusterJvmOptions clientJvmOptions = ClusterJvmOptions.build(config.getString(ExecutionConfigKeys.CLIENT_JVM_OPTIONS));
        clusterConfig.setClientJvmOptions(clientJvmOptions);
        clusterConfig.setClientVcores(config.getDouble(ExecutionConfigKeys.CLIENT_VCORES));
        clusterConfig.setClientMemoryMB(config.getInteger(ExecutionConfigKeys.CLIENT_MEMORY_MB));
        clusterConfig.setClientDiskGB(config.getInteger(ExecutionConfigKeys.CLIENT_DISK_GB));
        int driverMB = config.getInteger(ExecutionConfigKeys.DRIVER_MEMORY_MB);
        clusterConfig.setDriverMemoryMB(driverMB);
        int driverDiskGB = config.getInteger(ExecutionConfigKeys.DRIVER_DISK_GB);
        clusterConfig.setDriverDiskGB(driverDiskGB);
        ClusterJvmOptions driverJvmOptions = ClusterJvmOptions.build(config.getString(ExecutionConfigKeys.DRIVER_JVM_OPTION));
        clusterConfig.setDriverJvmOptions(driverJvmOptions);
        clusterConfig.setDriverVcores(config.getDouble(ExecutionConfigKeys.DRIVER_VCORES));
        int driverNum = config.getInteger(ExecutionConfigKeys.DRIVER_NUM);
        Preconditions.checkArgument((driverNum == 1 || driverNum > 1 && PipelineUtil.isAsync(config) ? 1 : 0) != 0, (Object)"only one driver is allowed in no-share mode");
        clusterConfig.setDriverNum(driverNum);
        clusterConfig.setContainerMemoryMB(config.getInteger(ExecutionConfigKeys.CONTAINER_MEMORY_MB));
        clusterConfig.setContainerDiskGB(config.getInteger(ExecutionConfigKeys.CONTAINER_DISK_GB));
        clusterConfig.setContainerVcores(config.getDouble(ExecutionConfigKeys.CONTAINER_VCORES));
        int workersPerContainer = config.getInteger(ExecutionConfigKeys.CONTAINER_WORKER_NUM);
        clusterConfig.setContainerWorkerNum(workersPerContainer);
        int containerNum = config.getInteger(ExecutionConfigKeys.CONTAINER_NUM);
        clusterConfig.setContainerNum(containerNum);
        if (config.contains(ExecutionConfigKeys.CONTAINER_JVM_OPTION)) {
            containerJvmOptions = ClusterJvmOptions.build(config.getString(ExecutionConfigKeys.CONTAINER_JVM_OPTION));
        } else {
            containerJvmOptions = new ClusterJvmOptions();
            containerJvmOptions.setMaxHeapMB((int)((double)driverMB * 0.8));
        }
        clusterConfig.setContainerJvmOptions(containerJvmOptions);
        config.put(ExecutionConfigKeys.CONTAINER_HEAP_SIZE_MB, String.valueOf(containerJvmOptions.getMaxHeapMB()));
        ClusterJvmOptions supervisorJvmOptions = ClusterJvmOptions.build(config.getString(ExecutionConfigKeys.SUPERVISOR_JVM_OPTIONS));
        clusterConfig.setSupervisorJvmOptions(supervisorJvmOptions);
        boolean isFoEnabled = config.getBoolean(ExecutionConfigKeys.FO_ENABLE);
        clusterConfig.setFoEnable(isFoEnabled);
        clusterConfig.setMaxRestarts(config.getInteger(ExecutionConfigKeys.FO_MAX_RESTARTS));
        FailoverStrategyType strategyType = FailoverStrategyType.valueOf(config.getString(ExecutionConfigKeys.FO_STRATEGY));
        if (!isFoEnabled || strategyType == FailoverStrategyType.disable_fo) {
            clusterConfig.setMaxRestarts(0);
            config.put(ExecutionConfigKeys.FO_STRATEGY, FailoverStrategyType.disable_fo.name());
        }
        clusterConfig.setConfig(config);
        return clusterConfig;
    }

    public int getContainerNum() {
        return this.containerNum;
    }

    public void setContainerNum(int containerNum) {
        this.containerNum = containerNum;
    }

    public int getContainerMemoryMB() {
        return this.containerMemoryMB;
    }

    public void setContainerMemoryMB(int containerMemoryMB) {
        this.containerMemoryMB = containerMemoryMB;
    }

    public int getContainerDiskGB() {
        return this.containerDiskGB;
    }

    public void setContainerDiskGB(int containerDiskGB) {
        this.containerDiskGB = containerDiskGB;
    }

    public int getContainerWorkerNum() {
        return this.containerWorkerNum;
    }

    public void setContainerWorkerNum(int containerWorkerNum) {
        this.containerWorkerNum = containerWorkerNum;
    }

    public double getContainerVcores() {
        return this.containerVcores;
    }

    public void setContainerVcores(double containerVcores) {
        this.containerVcores = containerVcores;
    }

    public int getMasterMemoryMB() {
        return this.masterMemoryMB;
    }

    public void setMasterMemoryMB(int masterMemoryMB) {
        this.masterMemoryMB = masterMemoryMB;
    }

    public int getDriverMemoryMB() {
        return this.driverMemoryMB;
    }

    public void setDriverMemoryMB(int driverMemoryMB) {
        this.driverMemoryMB = driverMemoryMB;
    }

    public int getMasterDiskGB() {
        return this.masterDiskGB;
    }

    public void setMasterDiskGB(int masterDiskGB) {
        this.masterDiskGB = masterDiskGB;
    }

    public int getDriverDiskGB() {
        return this.driverDiskGB;
    }

    public void setDriverDiskGB(int driverDiskGB) {
        this.driverDiskGB = driverDiskGB;
    }

    public ClusterJvmOptions getDriverJvmOptions() {
        return this.driverJvmOptions;
    }

    public void setDriverJvmOptions(ClusterJvmOptions driverJvmOptions) {
        this.driverJvmOptions = driverJvmOptions;
    }

    public ClusterJvmOptions getMasterJvmOptions() {
        return this.masterJvmOptions;
    }

    public void setMasterJvmOptions(ClusterJvmOptions masterJvmOptions) {
        this.masterJvmOptions = masterJvmOptions;
    }

    public double getMasterVcores() {
        return this.masterVcores;
    }

    public void setMasterVcores(double masterVcores) {
        this.masterVcores = masterVcores;
    }

    public double getDriverVcores() {
        return this.driverVcores;
    }

    public void setDriverVcores(double driverVcores) {
        this.driverVcores = driverVcores;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public boolean isFoEnable() {
        return this.isFoEnable;
    }

    public void setFoEnable(boolean isFoEnable) {
        this.isFoEnable = isFoEnable;
    }

    public int getMaxRestarts() {
        return this.maxRestarts;
    }

    public void setMaxRestarts(int maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    public int getDriverNum() {
        return this.driverNum;
    }

    public void setDriverNum(int driverNum) {
        this.driverNum = driverNum;
    }

    public ClusterJvmOptions getContainerJvmOptions() {
        return this.containerJvmOptions;
    }

    public void setContainerJvmOptions(ClusterJvmOptions containerJvmOptions) {
        this.containerJvmOptions = containerJvmOptions;
    }

    public ClusterJvmOptions getClientJvmOptions() {
        return this.clientJvmOptions;
    }

    public void setClientJvmOptions(ClusterJvmOptions clientJvmOptions) {
        this.clientJvmOptions = clientJvmOptions;
    }

    public double getClientVcores() {
        return this.clientVcores;
    }

    public void setClientVcores(double clientVcores) {
        this.clientVcores = clientVcores;
    }

    public int getClientMemoryMB() {
        return this.clientMemoryMB;
    }

    public void setClientMemoryMB(int clientMemoryMB) {
        this.clientMemoryMB = clientMemoryMB;
    }

    public int getClientDiskGB() {
        return this.clientDiskGB;
    }

    public void setClientDiskGB(int clientDiskGB) {
        this.clientDiskGB = clientDiskGB;
    }

    public int getDriverRegisterTimeoutSec() {
        return this.config.getInteger(ExecutionConfigKeys.FO_TIMEOUT_MS) / 1000;
    }

    public ClusterJvmOptions getSupervisorJvmOptions() {
        return this.supervisorJvmOptions;
    }

    public void setSupervisorJvmOptions(ClusterJvmOptions supervisorJvmOptions) {
        this.supervisorJvmOptions = supervisorJvmOptions;
    }

    public String toString() {
        return "ClusterConfig{containerNum=" + this.containerNum + ", containerMemoryMB=" + this.containerMemoryMB + ", containerWorkers=" + this.containerWorkerNum + ", containerJvmOptions=" + this.containerJvmOptions + ", masterMemoryMB=" + this.masterMemoryMB + ", masterJvmOptions=" + this.masterJvmOptions + ", driverMemoryMB=" + this.driverMemoryMB + ", driverJvmOptions=" + this.driverJvmOptions + ", restartAllFo=" + this.isFoEnable + '}';
    }
}

