/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.common;

import org.apache.geaflow.cluster.common.AbstractComponent;
import org.apache.geaflow.cluster.common.ComponentInfo;
import org.apache.geaflow.cluster.exception.ExceptionClient;
import org.apache.geaflow.cluster.exception.ExceptionCollectService;
import org.apache.geaflow.cluster.heartbeat.HeartbeatClient;
import org.apache.geaflow.cluster.web.metrics.MetricServer;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.common.config.keys.FrameworkConfigKeys;
import org.apache.geaflow.common.utils.ProcessUtil;
import org.apache.geaflow.ha.service.ResourceData;
import org.apache.geaflow.infer.InferEnvironmentManager;
import org.apache.geaflow.shuffle.service.ShuffleManager;

public abstract class AbstractContainer
extends AbstractComponent {
    protected HeartbeatClient heartbeatClient;
    protected ExceptionCollectService exceptionCollectService;
    protected MetricServer metricServer;
    protected int metricPort;
    protected int supervisorPort;
    protected boolean enableInfer;

    public AbstractContainer(int rpcPort) {
        super(rpcPort);
    }

    @Override
    public void init(int id, String name, Configuration configuration) {
        super.init(id, name, configuration);
        this.startRpcService();
        ShuffleManager.init((Configuration)configuration);
        ExceptionClient.init(id, name, this.masterId);
        this.heartbeatClient = new HeartbeatClient(id, name, configuration);
        this.exceptionCollectService = new ExceptionCollectService();
        this.metricServer = new MetricServer(configuration);
        this.metricPort = this.metricServer.start();
        this.supervisorPort = configuration.getInteger(ExecutionConfigKeys.SUPERVISOR_RPC_PORT);
        this.enableInfer = configuration.getBoolean(FrameworkConfigKeys.INFER_ENV_ENABLE);
        this.initInferEnvironment(configuration);
    }

    protected void registerToMaster() {
        this.heartbeatClient.init(this.masterId, this.buildComponentInfo());
    }

    @Override
    protected ResourceData buildResourceData() {
        ResourceData resourceData = super.buildResourceData();
        resourceData.setMetricPort(this.metricPort);
        resourceData.setSupervisorPort(this.supervisorPort);
        return resourceData;
    }

    protected abstract void startRpcService();

    protected abstract ComponentInfo buildComponentInfo();

    protected void fillComponentInfo(ComponentInfo componentInfo) {
        componentInfo.setId(this.id);
        componentInfo.setName(this.name);
        componentInfo.setHost(ProcessUtil.getHostIp());
        componentInfo.setPid(ProcessUtil.getProcessId());
        componentInfo.setRpcPort(this.rpcPort);
        componentInfo.setMetricPort(this.metricPort);
        componentInfo.setAgentPort(this.configuration.getInteger(ExecutionConfigKeys.AGENT_HTTP_PORT));
    }

    @Override
    public void close() {
        super.close();
        if (this.exceptionCollectService != null) {
            this.exceptionCollectService.shutdown();
        }
        if (this.heartbeatClient != null) {
            this.heartbeatClient.close();
        }
        if (this.metricServer != null) {
            this.metricServer.stop();
        }
    }

    private void initInferEnvironment(Configuration configuration) {
        if (this.enableInfer) {
            InferEnvironmentManager inferEnvironmentManager = InferEnvironmentManager.buildInferEnvironmentManager((Configuration)configuration);
            inferEnvironmentManager.createEnvironment();
        }
    }
}

